/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.database.sql.impl;

import com.bringspring.common.database.enums.DbAliasEnum;
import com.bringspring.common.database.enums.ParamEnum;
import com.bringspring.common.database.source.DbBase;
import com.bringspring.common.database.sql.SqlBase;
import com.bringspring.common.database.util.DbTypeUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.StringUtils;

public class SqlPostgre
extends SqlBase {
    @Override
    protected void init() {
        String fieldListSql = "SELECT\n\tbase.\"column_name\"\nFIELD_NAME,\n\tcol_description ( t1.oid, t2.attnum )\nFIELD_COMMENT,\n\tbase.udt_name\nDATATYPE,\n\tt2.attnotnull AS\tALLOW_NULL,\n\tCOALESCE(character_maximum_length, numeric_precision, datetime_precision)\nDATA_LENGTH,\n\t(CASE\n\t\tWHEN ( SELECT t2.attnum = ANY ( conkey ) FROM pg_constraint WHERE conrelid = t1.oid AND contype = 'p' ) = 't' \n\t\tTHEN 1 ELSE 0 \n\tEND ) \nPRIMARY_KEY\nFROM\n\tinformation_schema.COLUMNS base,\n\tpg_class t1,\n\tpg_attribute t2 \nWHERE\n\tbase.\"table_name\" = " + ParamEnum.TABLE.getParamSign() + " \n" + "\tAND t1.relname = base.\"table_name\" \n" + "\tAND t2.attname = base.\"column_name\" \n" + "\tAND t1.oid = t2.attrelid \n" + "\tAND t2.attnum > 0;\n";
        String tableListSql = "select relname as TABLE_NAME,cast(obj_description(relfilenode,'pg_class') as varchar) as TABLE_COMMENT,reltuples TABLE_SUM from pg_class c\nwhere relname in (select tablename from pg_tables where schemaname='public' and position('_2' in tablename)=0);";
        String existsTableSql = "select relname as TABLE_NAME from pg_class c\nwhere relname = " + ParamEnum.TABLE.getParamSign() + " ;";
        this.setInstance(fieldListSql, tableListSql, existsTableSql, "{table}:", "", "{table}");
    }

    @Override
    public String[] getPageSql(String sql, String sortType, Integer currentPage, Integer pageSize) throws DataException {
        DbBase dbBase = DbTypeUtil.getDriver("PostgreSQL");
        int startIndex = currentPage - 1;
        String sortSql = StringUtils.isEmpty(sortType) ? "" : " ORDER BY " + sortType;
        String dataListSql = sql + sortSql + " LIMIT " + pageSize + " OFFSET " + startIndex * pageSize + ";";
        String totalSql = "SELECT COUNT(*) " + DbAliasEnum.TOTAL_RECORD.asByDb(dbBase) + " FROM (" + sql + ") jsbos_tab;";
        return new String[]{dataListSql, totalSql};
    }
}

