/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.util;

import com.bringspring.common.database.data.DataSourceContextHolder;
import com.bringspring.common.util.CacheKeyUtil;
import com.bringspring.common.util.JsonUtil;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.stereotype.Component;

@Component
public class RedisUtil {
    private static final Logger log = LoggerFactory.getLogger(RedisUtil.class);
    public static final int CAHCETIME = 60;
    public static final int CAHCEHOUR = 3600;
    public static final int CAHCEDAY = 86400;
    public static final int CAHCEWEEK = 604800;
    public static final int CAHCEMONTH = 18144000;
    public static final int CAHCEYEAR = 217728000;
    private static long expiresIn = TimeUnit.SECONDS.toSeconds(28800L);
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private CacheKeyUtil cacheKeyUtil;

    public Set<String> getAllKeys() {
        String tenantId = DataSourceContextHolder.getDatasourceId();
        Set<Object> keys = Collections.emptySet();
        keys = tenantId == null ? this.redisTemplate.keys((Object)"*") : this.redisTemplate.keys((Object)("*" + tenantId + "*"));
        if (CollectionUtils.isNotEmpty((Collection)keys)) {
            keys = keys.stream().filter(s -> !s.startsWith(CacheKeyUtil.IDGENERATOR)).collect(Collectors.toSet());
        }
        return keys;
    }

    public Boolean setStringByAtomicity(String key, String value, Long timeout, TimeUnit timeUnit) throws Exception {
        return this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)value, timeout.longValue(), timeUnit);
    }

    public Set<String> getAllVisiualKeys() {
        HashSet<String> allKey = new HashSet<String>(16);
        allKey.addAll(Objects.requireNonNull(this.redisTemplate.keys((Object)("*" + this.cacheKeyUtil.getAllUser() + "*"))));
        allKey.addAll(Objects.requireNonNull(this.redisTemplate.keys((Object)("*" + this.cacheKeyUtil.getCompanySelect() + "*"))));
        allKey.addAll(Objects.requireNonNull(this.redisTemplate.keys((Object)("*" + this.cacheKeyUtil.getDictionary() + "*"))));
        allKey.addAll(Objects.requireNonNull(this.redisTemplate.keys((Object)("*" + this.cacheKeyUtil.getDynamic() + "*"))));
        allKey.addAll(Objects.requireNonNull(this.redisTemplate.keys((Object)("*" + this.cacheKeyUtil.getOrganizeList() + "*"))));
        allKey.addAll(Objects.requireNonNull(this.redisTemplate.keys((Object)("*" + this.cacheKeyUtil.getPositionList() + "*"))));
        allKey.addAll(Objects.requireNonNull(this.redisTemplate.keys((Object)("*" + this.cacheKeyUtil.getVisiualData() + "*"))));
        return allKey;
    }

    public Long getLiveTime(String key) {
        return this.redisTemplate.getExpire((Object)key);
    }

    public void remove(String key) {
        if (this.exists(key)) {
            this.redisTemplate.delete((Object)key);
        }
    }

    public void removeSome(String key) {
        Set keys = this.redisTemplate.keys((Object)("*visiualdata_" + key + "*"));
        if (CollectionUtils.isNotEmpty((Collection)keys)) {
            this.redisTemplate.delete((Collection)keys);
        }
    }

    public void removeUserToken(String userToken) {
        Set keys = this.redisTemplate.keys((Object)(userToken + "*"));
        if (CollectionUtils.isNotEmpty((Collection)keys)) {
            this.redisTemplate.delete((Collection)keys);
        }
    }

    public void removeAll() {
        Set<String> keys = this.getAllKeys();
        if (CollectionUtils.isNotEmpty(keys)) {
            this.redisTemplate.delete(keys);
        }
    }

    public boolean exists(String key) {
        return this.redisTemplate.hasKey((Object)key);
    }

    public void expire(String key, long time) {
        if (time > 0L) {
            this.redisTemplate.expire((Object)key, time, TimeUnit.SECONDS);
        } else {
            this.redisTemplate.expire((Object)key, expiresIn, TimeUnit.SECONDS);
        }
    }

    public void insert(String key, Object object) {
        this.insert(key, object, 0L);
    }

    public void insert(String key, Object object, long time) {
        if (object instanceof Map) {
            this.redisTemplate.opsForHash().putAll((Object)key, (Map)object);
        } else if (object instanceof List) {
            this.redisTemplate.opsForList().rightPush((Object)key, object);
        } else if (object instanceof Set) {
            this.redisTemplate.opsForSet().add((Object)key, ((Set)object).toArray());
        } else {
            this.redisTemplate.opsForValue().set((Object)key, (Object)this.toJson(object));
        }
        this.expire(key, time);
    }

    private String toJson(Object object) {
        if (object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double || object instanceof Boolean || object instanceof String) {
            return String.valueOf(object);
        }
        return JsonUtil.getObjectToString(object);
    }

    public void rename(String oldKey, String newKey) {
        this.redisTemplate.rename((Object)oldKey, (Object)newKey);
    }

    public String getType(String key) {
        return this.redisTemplate.type((Object)key).code();
    }

    public Object getString(String key) {
        return this.redisTemplate.opsForValue().get((Object)key);
    }

    public boolean hasKey(String hashId, String key) {
        return this.redisTemplate.opsForHash().hasKey((Object)hashId, (Object)key);
    }

    public List<String> getHashKeys(String hashId) {
        ArrayList<String> list = new ArrayList<String>();
        Map map = this.getMap(hashId);
        for (Object object : map.keySet()) {
            if (!(object instanceof String)) continue;
            list.add(String.valueOf(object));
        }
        return list;
    }

    public List<String> getHashValues(String hashId) {
        ArrayList<String> list = new ArrayList<String>();
        Map map = this.getMap(hashId);
        for (Object object : map.keySet()) {
            if (!(map.get(object) instanceof String)) continue;
            list.add(String.valueOf(map.get(object)));
        }
        return list;
    }

    public String getHashValues(String hashId, String key) {
        Object object = this.redisTemplate.opsForHash().get((Object)hashId, (Object)key);
        if (object != null) {
            return String.valueOf(object);
        }
        return null;
    }

    public void removeHash(String hashId, String key) {
        if (this.hasKey(hashId, key)) {
            this.redisTemplate.opsForHash().delete((Object)hashId, new Object[]{key});
        }
    }

    public <K, V> Map<K, V> getMap(String key) {
        return this.redisTemplate.opsForHash().entries((Object)key);
    }

    public void insertHash(String hashId, String key, String value) {
        this.redisTemplate.opsForHash().put((Object)hashId, (Object)key, (Object)value);
    }

    public Set<Object> getSet(String key) {
        try {
            return this.redisTemplate.opsForSet().members((Object)key);
        }
        catch (Exception e) {
            log.error(key, (Throwable)e);
            return null;
        }
    }

    public long getSetSize(String key) {
        try {
            return this.redisTemplate.opsForSet().size((Object)key);
        }
        catch (Exception e) {
            log.error(key, (Throwable)e);
            return 0L;
        }
    }

    public List<Object> get(String key, long start, long end) {
        try {
            return this.redisTemplate.opsForList().range((Object)key, start, end);
        }
        catch (Exception e) {
            log.error(key, (Throwable)e);
            return null;
        }
    }

    public long getListSize(String key) {
        try {
            return this.redisTemplate.opsForList().size((Object)key);
        }
        catch (Exception e) {
            log.error(key, (Throwable)e);
            return 0L;
        }
    }

    public Object getIndex(String key, long index) {
        try {
            return this.redisTemplate.opsForList().index((Object)key, index);
        }
        catch (Exception e) {
            log.error(key, (Throwable)e);
            return null;
        }
    }

    public Integer token(String tenantId) {
        Set data = this.redisTemplate.keys((Object)(tenantId + "login_online_" + "*"));
        return data.size();
    }

    public Boolean getLock(String key, String value) {
        Boolean lockStatus = this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)value, Duration.ofSeconds(5L));
        return lockStatus;
    }

    public Long releaseLock(String key, String value) {
        String luaScript = "if redis.call('get', KEYS[1]) == ARGV[1] then return redis.call('del', KEYS[1]) else return 0 end";
        DefaultRedisScript redisScript = new DefaultRedisScript(luaScript, Long.class);
        Long releaseStatus = (Long)this.redisTemplate.execute((RedisScript)redisScript, Collections.singletonList(key), new Object[]{value});
        return releaseStatus;
    }

    public boolean setKeyWithRetry(String key, String value, long expireTime, TimeUnit timeUnit, int maxRetries) {
        for (int attempts = 0; attempts < maxRetries; ++attempts) {
            Boolean result = this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)value, expireTime, timeUnit);
            if (Boolean.TRUE.equals(result)) {
                return true;
            }
            try {
                Thread.sleep(100 * attempts);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        }
        return false;
    }

    public boolean setKeyWithRetry(String key, String value, long expireTime, TimeUnit timeUnit) {
        Boolean result;
        while (!Boolean.TRUE.equals(result = this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)value, expireTime, timeUnit))) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        }
        return true;
    }
}

