/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.util.file.fileinfo;

import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.util.FileUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.file.FileExport;
import com.bringspring.common.util.file.UploadUtil;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DataFileExport
implements FileExport {
    private static final Logger log = LoggerFactory.getLogger(DataFileExport.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private ConfigValueUtil configValueUtil;

    @Override
    public DownloadVO exportFile(Object obj, String filePath, String fileName, String tableName) {
        String json = JsonUtil.getObjectToString(obj);
        fileName = fileName + System.currentTimeMillis() + "." + tableName;
        FileUtil.writeToFile(json, filePath, fileName);
        try {
            UploadUtil.uploadFile(this.configValueUtil.getFileType(), filePath + fileName, "export", fileName);
        }
        catch (IOException e) {
            log.error("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff0c\u9519\u8bef" + e.getMessage());
        }
        DownloadVO vo = DownloadVO.builder().name(fileName).url(UploaderUtil.uploaderFile(this.userProvider.get().getId() + "#" + fileName + "#" + "export")).build();
        return vo;
    }
}

