/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.database.util;

import com.bringspring.common.database.model.DataSourceModel;
import com.bringspring.common.database.model.dto.DataSourceDTO;
import com.bringspring.common.database.model.interfaces.DataSourceMod;
import com.bringspring.common.database.source.DbBase;
import com.bringspring.common.database.source.impl.DbDM;
import com.bringspring.common.database.source.impl.DbOracle;
import com.bringspring.common.database.util.DbTypeUtil;
import com.bringspring.common.exception.DataException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Properties;

public class ConnUtil {
    public static Connection getConn(DataSourceMod dbSourceOrDbLink) throws DataException {
        return ConnUtil.getConn(dbSourceOrDbLink, null);
    }

    public static Connection getConn(DataSourceMod dataSourceUtil, String dbName) throws DataException {
        DataSourceDTO dsd = dataSourceUtil.convertDTO(dbName);
        if (DbTypeUtil.checkOracle(dsd).booleanValue()) {
            return ConnUtil.getOracleConn(dsd);
        }
        return ConnUtil.getConn(dsd.getUserName(), dsd.getPassword(), ConnUtil.getUrl(dsd));
    }

    public static Connection getConn(String userName, String password, String url) throws DataException {
        DbBase db = DbTypeUtil.getDb(url);
        return ConnCommon.createConn(db.getDriver(), userName, password, url);
    }

    private static Connection getOracleConn(DataSourceDTO dsd) throws DataException {
        DbOracle dbOracle = new DbOracle();
        return dbOracle.getOracleConn(dsd, ConnUtil.getUrl(dsd));
    }

    public static String getUrl(DataSourceMod dbSourceOrDbLink) {
        return ConnUtil.getUrl(dbSourceOrDbLink, null);
    }

    public static String getUrl(DataSourceMod dbSourceOrDbLink, String dbName) {
        try {
            String dbSchema;
            DataSourceDTO dsd = dbSourceOrDbLink.convertDTO(dbName);
            DbBase db = DbTypeUtil.getDb(dbSourceOrDbLink);
            if (db.getClass() == DbOracle.class || db.getClass() == DbDM.class) {
                dbSchema = dsd.getDbSchema() != null && !dsd.getDbSchema().trim().isEmpty() ? dsd.getDbSchema() : dsd.getUserName();
                db.setOracleParam(dsd.getOracleParam());
            } else {
                dbSchema = dsd.getDbSchema();
            }
            dbName = dsd.getDbName() == null ? dsd.getUserName() : dsd.getDbName();
            String host = dsd.getHost() == null ? "127.0.0.1" : dsd.getHost();
            Integer port = dsd.getPort() == null ? Integer.parseInt(db.getDefaultPort()) : dsd.getPort();
            return DbBase.BaseCommon.getDbBaseConnUrl(db, dsd.getPrepareUrl(), host, port, dbName, dbSchema);
        }
        catch (DataException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static class ConnCommon {
        public static Connection createConn(String driver, String userName, String password, String url) throws DataException {
            try {
                Class.forName(driver);
                Properties props = new Properties();
                props.setProperty("user", userName);
                props.setProperty("password", password);
                props.setProperty("remarks", "true");
                props.setProperty("useInformationSchema", "true");
                return DriverManager.getConnection(url, props);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw DataException.errorLink(e.getMessage());
            }
        }

        public static Connection createConnByProp(String driver, String userName, String password, String url, Properties conProps) throws DataException {
            try {
                conProps.put("user", userName);
                conProps.put("password", password);
                Class.forName(driver);
                return DriverManager.getConnection(url, conProps);
            }
            catch (Exception e) {
                throw new DataException(e.getMessage());
            }
        }

        public static Connection getConnRemarks(DataSourceModel dbSourceOrDbLink) throws DataException {
            Properties props = new Properties();
            props.setProperty("remarks", "true");
            props.setProperty("useInformationSchema", "true");
            props.setProperty("remarksReporting", "true");
            return ConnCommon.createConnByProp(dbSourceOrDbLink.getDriver(), dbSourceOrDbLink.getUserName(), dbSourceOrDbLink.getPassword(), ConnUtil.getUrl(dbSourceOrDbLink), props);
        }
    }
}

