package com.bringspring.common.config;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.net.InetSocketAddress;
import java.net.Proxy;

/**
 * 设置代理配置
 */
@Component
@ConfigurationProperties(prefix = "config.proxy")
public class ProxyConfigProperties {
    /**
     * 是否开启代理服务
     * Whether to use a proxy server or not.
     */
    private boolean enabled=false;
    /**
     * 代理服务IP
     * The host of the proxy server.
     */
    private String host;
    /**
     * 代理服务端口
     * The port of the proxy server.
     */
    private Integer port;
    /**
     * 代理服务用户
     * The username for the proxy server.
     */
    private String username;
    /**
     * 代理服务密码
     * The password for the proxy server.
     */
    private String password;

    public boolean isEnabled() {
        return enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Integer getPort() {
        return port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
    //获取代理
    public Proxy getProxy() {
        if (!this.enabled) {
            return null;
        }
        Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.host, this.port));
        return proxy;
    }
}
