package com.bringspring.common.constant;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public enum MessageTypeConst {
    NOTHAVEATTACHMENT(20, "未上传合同附件"),

    RETURN_PLAN(21, "未到款提醒"),
    AFTER_SALES_DEAL_QUESTION(34, "售后问题处理通知"),
    AFTER_SALES_ASSGIN_QUESTION(35 ,"售后问题分派通知"),
    AFTER_SALES_ASSGIN_INSPECT(36 ,"巡检问题分派"),
    AFTER_SALES_WITHDRAW_INSPECT(37 ,"巡检任务撤回","inspectTaskWithdrawNoticeTemplate"),
    VISITFOLLOW_PUSH(38 ,"拜访跟进信息统计汇总（每周推送一次）"), //未使用
    VISIT_PUSH_LEADER(50 ,"推送拜访外出数据给领导"),
    PROJECT_REPORT_AUDIT_PUSH(60 ,"项目报备审核通知","projectReportingPushTemplate"),
    PROJECT_REPORT_NEED_AUDIT(61 ,"项目报备审核通知","projectReportingNeedAuditTemplate"),
    PROJECT_REPORT_FOLLOW(64 ,"项目报备跟进通知（给负责人）","projectReportingFollowNoticeTemplate"),
    PROJECT_REPORT_TRANSFER(65 ,"项目报备转移通知","projectReportingTransferNoticeTemplate"),
    MARKET_LOG(62 ,"销售提交日志通知","marketLog"),
    ;
    private Integer type;

    private String message;

    private String templateCode;

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getTemplateCode() {
        return templateCode;
    }

    public void setTemplateCode(String templateCode) {
        this.templateCode = templateCode;
    }

    MessageTypeConst(Integer type, String message) {
        this.type = type;
        this.message = message;
    }

    MessageTypeConst(Integer type, String message, String templateCode) {
        this.type = type;
        this.message = message;
        this.templateCode = templateCode;
    }

    /**
     * 获得所有枚举类型到list
     * @return
     */
    public static List<MessageTypeConst> getAllToList() {
        List<MessageTypeConst> list = new ArrayList<>();
        MessageTypeConst[] values = values();
        Collections.addAll(list, values);
        return list;
    }


}
