package com.bringspring.common.database.source.impl;

import com.baomidou.mybatisplus.annotation.DbType;
import com.bringspring.common.database.constant.DbAliasConst;
import com.bringspring.common.database.enums.DbAliasEnum;
import com.bringspring.common.database.model.DataTypeModel;
import com.bringspring.common.database.model.DbTableFieldModel;
import com.bringspring.common.database.source.DbBase;
import com.bringspring.common.database.sql.impl.SqlMySQL;
import com.bringspring.common.util.StringUtils;

import java.sql.ResultSet;

/**
 * MySQL模型
 *
 * @author RKKJ开发平台组 YY
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/10/06
 */
public class DbMySQL extends DbBase {

    @Override
    protected void init(){
        setInstance(
                DbBase.MYSQL,
                DbType.MYSQL,
                "3306",
                "mysql",
                "com.mysql.cj.jdbc.Driver",
                "jdbc:mysql://{host}:{port}/{dbname}?useUnicode=true&autoReconnect=true&characterEncoding=utf-8&allowMultiQueries=true&allowPublicKeyRetrieval=true&serverTimezone=GMT%2B8&useSSL=false",
                //connUrl = "jdbc:mysql://{host}:{port}/{dbname}?useUnicode=true&autoReconnect=true&characterEncoding=utf8&useSSL=false&serverTimezone=GMT%2B8";
                new SqlMySQL());
    }

    @Override
    public DbTableFieldModel getPartFieldModel(ResultSet result) throws Exception {
        DbTableFieldModel model = new DbTableFieldModel();
        // 精度
        String precision = result.getString(DbAliasConst.PRECISION);
        DataTypeModel dataTypeModel = getDataTypeModel(result.getString(DbAliasEnum.getAsByDb(this, DbAliasConst.DATA_TYPE)));
        if (dataTypeModel != null) {
            if (!StringUtils.isEmpty(precision) || dataTypeModel.getPrecisionMax() != null) {
                model.setDataLength(precision + "," + result.getString(DbAliasConst.DECIMALS));
            }
        }
        return model;
    }

}
