package com.bringspring.common.util.enums;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 日期格式化分类枚举
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021-10-27
 */
public enum DateFormatEnum {
    /**
     * 年
     */
    YYYY("yyyy"),
    /**
     * 年月
     */
    YYYY_MM("yyyy-MM"),
    /**
     * 年月日
     */
    YYYY_MM_DD("yyyy-MM-dd"),
    /**
     * 年月日时
     */
    YYYY_MM_DD_HH("yyyy-MM-dd HH"),
    /**
     * 年月日时分
     */
    YYYY_MM_DD_HH_MM("yyyy-MM-dd HH:mm"),
    /**
     * 年月日时分秒
     */
    YYYY_MM_DD_HH_MM_SS("yyyy-MM-dd HH:mm:ss"),
    ;

    DateFormatEnum(String format) {
        this.format = format;
    }

    private String format;

    public String getFormat() {
        return format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public static List<Map<String, Object>> getFormatOptions() {
        List<Map<String, Object>> options = new ArrayList<>();
        options.add(new HashMap<String, Object>() {{
            put("value", YYYY.getFormat());
            put("label", YYYY.getFormat());
        }});
        options.add(new HashMap<String, Object>() {{
            put("value", YYYY_MM.getFormat());
            put("label", YYYY_MM.getFormat());
        }});
        options.add(new HashMap<String, Object>() {{
            put("value", YYYY_MM_DD.getFormat());
            put("label", YYYY_MM_DD.getFormat());
        }});
//        options.add(new HashMap<String, String>() {{
//            put("value", YYYY_MM_DD_HH.getFormat());
//            put("label", YYYY_MM_DD_HH.getFormat());
//        }});
        options.add(new HashMap<String, Object>() {{
            put("value", YYYY_MM_DD_HH_MM.getFormat());
            put("label", YYYY_MM_DD_HH_MM.getFormat());
        }});
        options.add(new HashMap<String, Object>() {{
            put("value", YYYY_MM_DD_HH_MM_SS.getFormat());
            put("label", YYYY_MM_DD_HH_MM_SS.getFormat());
        }});
        return options;
    }

}
