/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.database.plugins;

import com.alibaba.druid.pool.DruidDataSource;
import com.baomidou.dynamic.datasource.DynamicRoutingDataSource;
import com.baomidou.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import com.bringspring.common.database.data.DataSourceContextHolder;
import com.bringspring.common.database.model.TenantLinkModel;
import com.bringspring.common.database.util.DbTypeUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.CacheUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.ParameterUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.context.SpringContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class}), @Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class MyMasterSlaveAutoRoutingPlugin
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(MyMasterSlaveAutoRoutingPlugin.class);
    protected DynamicRoutingDataSource dynamicDataSource;

    public MyMasterSlaveAutoRoutingPlugin(DataSource dataSource) {
        this.dynamicDataSource = (DynamicRoutingDataSource)dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object intercept(Invocation invocation) throws Throwable {
        Object[] args = invocation.getArgs();
        if (!"true".equals(DataSourceContextHolder.getDatasourceName())) {
            return invocation.proceed();
        }
        MappedStatement ms = (MappedStatement)args[0];
        String pushedDataSource = null;
        try {
            String dataSource;
            String tenantId = StringUtils.isNotEmpty(DataSourceContextHolder.getDatasourceId()) ? DataSourceContextHolder.getDatasourceId() : "";
            String string = dataSource = SqlCommandType.SELECT == ms.getSqlCommandType() ? "slave" : "master";
            if ("slave".equals(dataSource)) {
                if (!this.dynamicDataSource.getGroupDataSources().containsKey(tenantId + "-" + "slave")) {
                    if (this.dynamicDataSource.getGroupDataSources().containsKey(tenantId + "-" + "master")) {
                        dataSource = tenantId + "-" + "master";
                    }
                } else {
                    dataSource = tenantId + "-" + "slave";
                }
            } else {
                dataSource = tenantId + "-" + dataSource;
            }
            if (!this.dynamicDataSource.getGroupDataSources().containsKey(dataSource)) {
                dataSource = tenantId + "-" + dataSource;
                CacheUtil cacheUtil = SpringContext.getBean(CacheUtil.class);
                if (cacheUtil.exists("foreverCacheSpace", tenantId)) {
                    Object string2 = cacheUtil.query("foreverCacheSpace", tenantId);
                    List<TenantLinkModel> linkList = JsonUtil.getJsonToList(String.valueOf(string2), TenantLinkModel.class);
                    ArrayList<String> list = new ArrayList<String>(16);
                    for (TenantLinkModel model : linkList) {
                        DruidDataSource druidDataSource = new DruidDataSource();
                        if (StringUtils.isNotEmpty(model.getConnectionStr())) {
                            druidDataSource.setUrl(model.getConnectionStr());
                        } else {
                            druidDataSource.setUrl(ParameterUtil.getUrl(model));
                        }
                        druidDataSource.setUsername(model.getUserName());
                        druidDataSource.setPassword(model.getPassword());
                        try {
                            druidDataSource.setDriverClassName(DbTypeUtil.getDriver(model.getDbType()).getDriver());
                        }
                        catch (DataException e) {
                            e.printStackTrace();
                        }
                        String masterCode = tenantId + "-master_" + RandomUtil.uuId();
                        String slaveCode = tenantId + "-slave_" + RandomUtil.uuId();
                        if ("0".equals(String.valueOf(model.getConfigType()))) {
                            this.dynamicDataSource.addDataSource(masterCode, (DataSource)druidDataSource);
                            list.add(masterCode);
                            continue;
                        }
                        this.dynamicDataSource.addDataSource(slaveCode, (DataSource)druidDataSource);
                        list.add(slaveCode);
                    }
                }
            }
            pushedDataSource = DynamicDataSourceContextHolder.push((String)dataSource);
            Object object = invocation.proceed();
            return object;
        }
        finally {
            if (pushedDataSource != null) {
                DynamicDataSourceContextHolder.poll();
            }
        }
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

