/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.util.minio;

import com.bringspring.common.util.FileUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.XSSEscape;
import io.minio.BucketExistsArgs;
import io.minio.CopyObjectArgs;
import io.minio.CopySource;
import io.minio.GetObjectArgs;
import io.minio.GetObjectResponse;
import io.minio.GetPresignedObjectUrlArgs;
import io.minio.ListObjectsArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import io.minio.RemoveBucketArgs;
import io.minio.RemoveObjectArgs;
import io.minio.Result;
import io.minio.SetBucketPolicyArgs;
import io.minio.http.Method;
import io.minio.messages.Bucket;
import io.minio.messages.Item;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class MinioUploadUtil {
    private static final Logger log = LoggerFactory.getLogger(MinioUploadUtil.class);
    @Resource(name="minioClient")
    private MinioClient minioClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadFile(MultipartFile file, String bucketName, String fileName) {
        if (null == file || 0L == file.getSize()) {
            log.error("\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.bucketExists(bucketName);
        if (file != null) {
            String originalFilename = file.getOriginalFilename();
            assert (originalFilename != null);
            try {
                InputStream inputStream = file.getInputStream();
                try {
                    this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucketName)).object(fileName)).stream(inputStream, file.getSize(), -1L).contentType(file.getContentType()).build());
                }
                finally {
                    if (Collections.singletonList(inputStream).get(0) != null) {
                        inputStream.close();
                    }
                }
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadFiles(String filePath, String bucketName, String fileName) throws IOException {
        MultipartFile file = FileUtil.createFileItem(new File(XSSEscape.escapePath(filePath)));
        try {
            InputStream inputStream = file.getInputStream();
            try {
                this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucketName)).object(fileName)).stream(inputStream, file.getSize(), -1L).contentType(file.getContentType()).build());
            }
            finally {
                if (Collections.singletonList(inputStream).get(0) != null) {
                    inputStream.close();
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downFile(String fileName, String bucketName, String downName) {
        InputStream inputStream = null;
        try {
            inputStream = this.minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucketName)).object(fileName)).build());
            HttpServletResponse response = ServletUtils.getResponse();
            HttpServletRequest request = ServletUtils.getRequest();
            try {
                BufferedInputStream bis = new BufferedInputStream(inputStream);
                try {
                    if (StringUtils.isNotEmpty(downName)) {
                        fileName = downName;
                    }
                    response.setCharacterEncoding("UTF-8");
                    response.setContentType("text/plain");
                    if (fileName.contains(".svg")) {
                        response.setContentType("image/svg+xml");
                    }
                    String codeFileName = "";
                    String agent = request.getHeader("USER-AGENT").toLowerCase();
                    codeFileName = -1 != agent.indexOf("msie") || -1 != agent.indexOf("trident") ? URLEncoder.encode(fileName, "UTF-8") : (-1 != agent.indexOf("mozilla") ? new String(fileName.getBytes("UTF-8"), "iso-8859-1") : URLEncoder.encode(fileName, "UTF-8"));
                    response.setHeader("Content-Disposition", "attachment;filename=" + XSSEscape.escape(new String(codeFileName.getBytes(), "utf-8")));
                    ServletOutputStream os = response.getOutputStream();
                    try {
                        int i;
                        byte[] buff = new byte[8192];
                        while ((i = bis.read(buff)) != -1) {
                            os.write(buff, 0, i);
                        }
                        os.flush();
                    }
                    finally {
                        if (Collections.singletonList(os).get(0) != null) {
                            os.close();
                        }
                    }
                }
                finally {
                    if (Collections.singletonList(bis).get(0) != null) {
                        bis.close();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dowloadMinioFile(String fileName, String bucketName) {
        try {
            GetObjectResponse inputStream = this.minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucketName)).object(fileName)).build());
            try {
                ServletOutputStream outputStream1 = ServletUtils.getResponse().getOutputStream();
                try {
                    BufferedOutputStream outputStream = new BufferedOutputStream((OutputStream)outputStream1);
                    try {
                        int n;
                        byte[] buff = new byte[1024];
                        while ((n = inputStream.read(buff)) != -1) {
                            ((OutputStream)outputStream).write(buff, 0, n);
                        }
                        ((OutputStream)outputStream).flush();
                    }
                    finally {
                        if (Collections.singletonList(outputStream).get(0) != null) {
                            ((OutputStream)outputStream).close();
                        }
                    }
                }
                finally {
                    if (Collections.singletonList(outputStream1).get(0) != null) {
                        outputStream1.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(inputStream).get(0) != null) {
                    inputStream.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getFile(String fileName, String bucketName) {
        String objectUrl = null;
        try {
            objectUrl = this.minioClient.getPresignedObjectUrl((GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().method(Method.GET).bucket(bucketName)).object(fileName)).build());
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return objectUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream downloadMinio(String fileName, String bucketName) {
        GetObjectResponse getObjectResponse;
        block6: {
            GetObjectResponse stream = this.minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucketName)).object(fileName)).build());
            try {
                getObjectResponse = stream;
                if (Collections.singletonList(stream).get(0) == null) break block6;
            }
            catch (Throwable throwable) {
                try {
                    if (Collections.singletonList(stream).get(0) != null) {
                        stream.close();
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.info(e.getMessage());
                    return null;
                }
            }
            stream.close();
        }
        return getObjectResponse;
    }

    public List<String> getAllBuckets() throws Exception {
        return this.minioClient.listBuckets().stream().map(Bucket::name).collect(Collectors.toList());
    }

    public void removeBucket(String bucketName) throws Exception {
        this.minioClient.removeBucket((RemoveBucketArgs)((RemoveBucketArgs.Builder)RemoveBucketArgs.builder().bucket(bucketName)).build());
    }

    public boolean removeFile(String bucketName, String name) {
        boolean isOK = true;
        try {
            this.minioClient.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(bucketName)).object(name)).build());
        }
        catch (Exception e) {
            e.printStackTrace();
            isOK = false;
        }
        return isOK;
    }

    public boolean bucketExists(String name) {
        boolean isExist = false;
        try {
            isExist = this.minioClient.bucketExists(MinioUploadUtil.getBucketExistsArgs(name));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isExist;
    }

    public void bucketExistsCreate(String name) {
        try {
            this.minioClient.bucketExists(MinioUploadUtil.getBucketExistsArgs(name));
            this.minioClient.makeBucket(MinioUploadUtil.getMakeBucketArgs(name));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean putFolder(String filePath, String bucketName, String objectName) {
        boolean flag = false;
        try {
            if (!FileUtil.fileIsExists(filePath)) {
                return false;
            }
            FileUtil.toZip(filePath + ".zip", true, filePath);
            MultipartFile multipartFile = FileUtil.createFileItem(new File(XSSEscape.escapePath(filePath + ".zip")));
            this.uploadFile(multipartFile, bucketName, objectName + ".zip");
            flag = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void streamToDown(String bucketName, String filePath, String objectName) {
        try {
            GetObjectResponse stream = this.minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucketName)).object(objectName)).build());
            try {
                FileUtil.writeFile((InputStream)stream, filePath, objectName);
            }
            finally {
                if (Collections.singletonList(stream).get(0) != null) {
                    stream.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info(e.getMessage());
        }
    }

    public List getFileList(String bucketName) {
        ArrayList<Item> list = new ArrayList<Item>();
        try {
            Iterable results = this.minioClient.listObjects((ListObjectsArgs)((ListObjectsArgs.Builder)ListObjectsArgs.builder().bucket(bucketName)).build());
            for (Result result : results) {
                Item item = (Item)result.get();
                list.add(item);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return list;
    }

    public List getFileList(String bucketName, String type) {
        ArrayList<Item> list = new ArrayList<Item>();
        try {
            Iterable results = this.minioClient.listObjects((ListObjectsArgs)((ListObjectsArgs.Builder)ListObjectsArgs.builder().bucket(bucketName)).prefix(type).recursive(true).build());
            for (Result result : results) {
                Item item = (Item)result.get();
                list.add(item);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return list;
    }

    public void copyObject(String bucketName, String objectName, String copyToBucketName, String copyToObjectName) {
        try {
            this.minioClient.copyObject((CopyObjectArgs)((CopyObjectArgs.Builder)((CopyObjectArgs.Builder)CopyObjectArgs.builder().source((CopySource)((CopySource.Builder)((CopySource.Builder)CopySource.builder().bucket(bucketName)).object(objectName)).build()).bucket(copyToBucketName)).object(copyToObjectName)).build());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static MakeBucketArgs getMakeBucketArgs(String name) {
        return (MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(name)).build();
    }

    public static BucketExistsArgs getBucketExistsArgs(String name) {
        return (BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(name)).build();
    }

    public static SetBucketPolicyArgs getSetBucketPolicyArgs(String name) {
        return (SetBucketPolicyArgs)((SetBucketPolicyArgs.Builder)SetBucketPolicyArgs.builder().bucket(name)).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downToLocal(String bucketName, String filePath, String objectName) {
        try {
            GetObjectResponse stream = this.minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucketName)).object(objectName)).build());
            try {
                FileUtil.write((InputStream)stream, filePath, objectName);
            }
            finally {
                if (Collections.singletonList(stream).get(0) != null) {
                    stream.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info(e.getMessage());
        }
    }
}

