package com.bringspring.common.database.model;

import com.baomidou.mybatisplus.annotation.TableField;
import com.bringspring.common.database.model.dto.DataSourceDTO;
import com.bringspring.common.database.model.interfaces.DataSourceMod;
import com.bringspring.common.util.StringUtils;
import lombok.Data;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * 数据源基础工具类
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/3/16 8:49
 */
@Data
@Component
@ConfigurationProperties(prefix = "spring.datasource")
public class DataSourceModel implements DataSourceMod {

    /**
     * 数据库类型
     */
    @TableField("DB_TYPE")
    private String dbType;

    /**
     * 主机ip
     */
    @TableField("HOST")
    private String host;

    /**
     * 端口
     */
    @TableField("PORT")
    private Integer port;

    /**
     * 默认库名
     */
    @TableField("DB_NAME")
    private String dbName;

    /**
     * 用户
     */
    @TableField("USER_NAME")
    private String userName;

    /**
     * 密码
     */
    @TableField("PASSWORD")
    private String password;

    /**
     * 表空间
     */
    @TableField(value = "TABLE_SPACE")
    private String dbTableSpace;

    /**
     * 模式
     */
    @TableField(value = "DB_SCHEMA")
    private String dbSchema;

    /**
     * 数据连接jdbc-url参数
     */
    @TableField(exist = false)
    private String urlParams;

    /**
     * url地址
     */
    @TableField(exist = false)
    private String url;

    /**
     * 数据连接jdbc-url参数
     */
    @TableField(exist = false)
    private String prepareUrl;

    /**
     * 驱动包
     */
    @TableField(exist = false)
    private String driver;

    /**
     * oracle多方式登录参数
     */
    @TableField(value = "Oracle_Param")
    private String oracleParam;

    /**
     * -- 这里的参数dataSourceUtil是spring托管的全局唯一变量，
     * New对象防止数据源互串，防止Bean覆盖
     */
    @Override
    public DataSourceDTO convertDTO(){
        return convertDTO(null);
    }

    @Override
    public DataSourceDTO convertDTO(String dbName){
        return convertDTO(dbName, 1);
    }

    protected DataSourceDTO convertDTO(String dbName, Integer dataSourceFrom){
        DataSourceDTO dataSourceDTO = new DataSourceDTO();
        BeanUtils.copyProperties(this, dataSourceDTO);
        if(StringUtils.isNotEmpty(dbName)){
            dataSourceDTO.setDbName(dbName);
        }
        dataSourceDTO.setDataSourceFrom(dataSourceFrom);
        return dataSourceDTO;
    }

}
