package com.bringspring.common.model.filedownlog;


import lombok.Data;

import java.util.Date;


/**
 * @版本： V1.0.0
 * @版权： 荣科科技股份有限公司
 * @作者： RKKJ开发平台组
 * @日期： 2025-03-13
 */
@Data
public class FileDownLogCrForm {


    /**
     * 主键
     **/
    private String id;

    /**
     * 存储引擎
     **/
    private String engine;

    /**
     * 存储桶
     **/
    private String bucket;

    /**
     * 文件id
     **/
    private String fileId;

    /**
     * 文件名称
     **/
    private String fileName;

    /**
     * 文件后缀
     **/
    private String suffix;

    /**
     * 文件大小
     **/
    private String sizeInfo;

    /**
     * 文件的对象名（唯一名称）
     **/
    private String objName;

    /**
     * 文件存储路径
     **/
    private String storagePath;

    /**
     * 文件二级存储路径
     **/
    private String secondFilePath;

    /**
     * 图片缩略图
     **/
    private String thumbnail;

    /**
     * 文件版本
     **/
    private String fileVersion;

    /**
     * 文件一级存储路径 license :临时文件存储路径 document : 文档管理存储路径
     **/
    private String fileType;

    /**
     * 上传方式: 1.local 本地上传  2.http http上传  3.create 新建
     **/
    private String type;

    /**
     * 下载链接
     **/
    private String url;

    /**
     * 模块类型/业务类型
     **/
    private String modular;

    /**
     * 业务id
     **/
    private String businessId;

    /**
     * 文件MD5
     **/
    private String fileDigest;

    /**
     * 创建用户id
     **/
    private String creatorUserId;
    private String creatorUserName;

    /**
     * 创建时间
     **/
    private Date creatorTime;

    /**
     *
     **/
    private String oldFileVersionId;


}