package com.bringspring.common.util;

import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.base.ActionResultCode;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.model.OnlineUserModel;
import com.bringspring.common.model.OnlineUserProvider;
import com.bringspring.common.util.jwt.JwtUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import static com.bringspring.common.constant.CacheConsts.LOGIN_CACHE;

/**
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/3/16 8:59
 */
@Component
public class UserProvider {

    @Autowired
    private CacheKeyUtil cacheKeyUtil;
    @Autowired
    private CacheUtil cacheUtil;

    /**
     * 获取token
     */
    public static String getToken() {
        String toke = getAuthorize();
        return toke;
    }

    /**
     * 获取
     *
     * @param token
     * @return
     */
    public UserInfo get(String token) {
        UserInfo userInfo = new UserInfo();
        String tokens = null;


        if (token != null) {
            tokens = JwtUtil.getRealToken(token);
        } else {
            tokens = UserProvider.getToken();
            tokens = JwtUtil.getRealToken(tokens);
        }
        if (tokens != null) {
            Object tokensVal = cacheUtil.query(LOGIN_CACHE, tokens);
            if (tokensVal instanceof String) {
                userInfo = JsonUtil.getJsonToBean(String.valueOf(tokensVal), UserInfo.class);
            } else {
                userInfo = (UserInfo) tokensVal;
            }
        }
        if (userInfo == null) {
            userInfo = new UserInfo();
        }
        return userInfo;
    }

    /**
     * 通过上下文的租户查redis来获取token
     *
     * @return
     */
    public UserInfo get(String userId, String tenantId) {
        UserInfo userInfo;
        tenantId = "null".equals(String.valueOf(tenantId)) ? "" : tenantId;
        String token = tenantId + "login_online_" + userId;
        if (ServletUtils.getIsMobileDevice()) {
            token = tenantId + "login_online_mobile_" + userId;
        }
        String OnlineInfo = String.valueOf(cacheUtil.query(LOGIN_CACHE, token));
        Object OnlineInfoVal = cacheUtil.query(LOGIN_CACHE, OnlineInfo);
        userInfo = JsonUtil.getJsonToBean(String.valueOf(OnlineInfoVal), UserInfo.class);
        return userInfo == null ? new UserInfo() : userInfo;
    }

    /**
     * 获取
     *
     * @return
     */
    public UserInfo get() {
        String token = UserProvider.getToken();
        return this.get(token);
    }

    /**
     * 获取Authorize
     */
    public static String getAuthorize() {
        String authorize = ServletUtils.getHeader("Authorization");
        return authorize;
    }

    /**
     * 创建
     *
     * @param userInfo
     * @return
     */
    public void add(UserInfo userInfo) {
        String userId = userInfo.getUserId();
        long time = DateUtil.getTime(userInfo.getOverdueTime()) - DateUtil.getTime(new Date());

        Object UserAuthorizeUserId = cacheUtil.query(LOGIN_CACHE, cacheKeyUtil.getUserAuthorize() + userId);
        String authorize = String.valueOf(UserAuthorizeUserId);
        String loginOnlineKey = cacheKeyUtil.getLoginOnline() + userId;
        cacheUtil.remove(LOGIN_CACHE, authorize);
        //记录Token
        cacheUtil.insert(LOGIN_CACHE, userInfo.getId(), userInfo, time);
        //记录在线
        if (ServletUtils.getIsMobileDevice()) {
            String key = cacheKeyUtil.getMobileLoginOnline() + userId;
            cacheUtil.insert(LOGIN_CACHE, key, userInfo.getId(), time);
            //记录移动设备CID,用于消息推送
            if (ServletUtils.getHeader("clientId") != null) {
                String clientId = ServletUtils.getHeader("clientId");
                Map<String, String> map = new HashMap<>(16);
                map.put(userInfo.getUserId(), clientId);
                cacheUtil.insert(LOGIN_CACHE, cacheKeyUtil.getMobileDeviceList(), map);
            }
        } else {
            cacheUtil.insert(LOGIN_CACHE, loginOnlineKey, userInfo.getId(), time);
        }
    }

    /**
     * 移除在线
     */
    public void removeWebSocket(UserInfo userInfo) {
        //清除websocket登录状态
        boolean isMobileDevice = ServletUtils.getIsMobileDevice();
        String userId = String.valueOf(userInfo.getUserId());
        String tenandId = "null".equals(String.valueOf(userInfo.getTenantId())) ? "" : userInfo.getTenantId();
        OnlineUserModel user =
                OnlineUserProvider.getOnlineUserList().stream().filter(t -> userId.equals(t.getUserId()) && tenandId.equals(t.getTenantId()) && isMobileDevice == t.getIsMobileDevice()).findFirst().orElse(null);
        if (user != null) {
            JSONObject object = new JSONObject();
            object.put("method", "logout");
            object.put("msg", ActionResultCode.SessionOffLine.getMessage());
            user.getWebSocket().getAsyncRemote().sendText(object.toJSONString());
        }
    }


    /**
     * 移除
     */
    public void remove() {
        UserInfo userInfo = this.get();
        String userId = userInfo.getUserId();

        if (ServletUtils.getIsMobileDevice()) {
            cacheUtil.removeHash(LOGIN_CACHE, cacheKeyUtil.getMobileDeviceList(), userId);
        }
        if (userInfo.getId() != null) {
            cacheUtil.remove(LOGIN_CACHE, userInfo.getId());
        }
        cacheUtil.remove(LOGIN_CACHE, cacheKeyUtil.getUserAuthorize() + userId);
        cacheUtil.remove(LOGIN_CACHE, cacheKeyUtil.getLoginOnline() + userId);
        cacheUtil.remove(LOGIN_CACHE, cacheKeyUtil.getSystemInfo());
    }

    /**
     * 移除当前登陆人的token
     */
    public void removeCurrent() {
        UserInfo userInfo = this.get();
        String userId = userInfo.getUserId();
        if (ServletUtils.getIsMobileDevice()) {
            String MobileLoginOnlineUserId = cacheKeyUtil.getMobileLoginOnline() + userInfo.getUserId();
            String key = String.valueOf(cacheUtil.query(LOGIN_CACHE, MobileLoginOnlineUserId));
            cacheUtil.remove(LOGIN_CACHE, key);
            cacheUtil.remove(LOGIN_CACHE, MobileLoginOnlineUserId);
        } else {
            String LoginOnlineUserId = cacheKeyUtil.getLoginOnline() + userInfo.getUserId();
            String key = String.valueOf(cacheUtil.query(LOGIN_CACHE, LoginOnlineUserId));
            cacheUtil.remove(LOGIN_CACHE, key);
            cacheUtil.remove(LOGIN_CACHE, LoginOnlineUserId);
        }
        cacheUtil.remove(LOGIN_CACHE, cacheKeyUtil.getUserAuthorize() + userId);
        cacheUtil.remove(LOGIN_CACHE, cacheKeyUtil.getSystemInfo());
    }

    /**
     * 移除在线
     */
    public void removeOnLine(String userId) {

        if (userId == null) {
            return;
        }
        String LoginOnlineUserId = cacheKeyUtil.getLoginOnline() + userId;
        String onlineToken = String.valueOf(cacheUtil.query(LOGIN_CACHE, LoginOnlineUserId));
        String MobileLoginOnlineUserId = cacheKeyUtil.getMobileLoginOnline() + userId;
        String mobileOnlineToken = String.valueOf(cacheUtil.query(LOGIN_CACHE, MobileLoginOnlineUserId));
        if (!org.apache.commons.lang3.StringUtils.isEmpty(onlineToken)) {
            cacheUtil.remove(LOGIN_CACHE, LoginOnlineUserId);
            cacheUtil.remove(LOGIN_CACHE, onlineToken);
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty(mobileOnlineToken)) {
            cacheUtil.remove(LOGIN_CACHE, MobileLoginOnlineUserId);
            cacheUtil.remove(LOGIN_CACHE, mobileOnlineToken);
            cacheUtil.removeHash(LOGIN_CACHE, cacheKeyUtil.getMobileDeviceList(), userId);
        }
    }

    /**
     * 是否在线
     */
    public boolean isOnLine() {
        UserInfo userInfo = this.get();
        String online;
        if (ServletUtils.getIsMobileDevice()) {
            online = userInfo.getTenantId() + "login_online_mobile_" + userInfo.getUserId();
        } else {
            online = userInfo.getTenantId() + "login_online_" + userInfo.getUserId();
        }
        //判断是否在线
        if (cacheUtil.exists(LOGIN_CACHE, online)) {
            //判断在线的token是否正确
            if (userInfo.getId().equals(cacheUtil.query(LOGIN_CACHE, online).toString())) {
                return true;
            }
        }
        return false;
    }

    /**
     * 是否过期
     */
    public boolean isOverdue() {
        UserInfo userInfo = this.get();
        return StringUtils.isEmpty(userInfo.getId()) ? false : true;
    }

    /**
     * 是否登陆
     */
    public boolean isLogined() {

        UserInfo userInfo = this.get();
        String userOnline = (ServletUtils.getIsMobileDevice() == true ? cacheKeyUtil.getMobileLoginOnline() :
                cacheKeyUtil.getLoginOnline()) + userInfo.getUserId();
        Object online = cacheUtil.query(LOGIN_CACHE, userOnline);
        return online == null ? true : false;
    }

}
