/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.base;

import com.bringspring.common.base.ActionResultCode;
import com.bringspring.common.base.PageModel;
import com.bringspring.common.base.vo.DataInterfacePageListVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.constant.MsgCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ActionResult<T> {
    @ApiModelProperty(value="\u72b6\u6001\u7801")
    private Integer code;
    @ApiModelProperty(value="\u8fd4\u56de\u4fe1\u606f")
    private String msg;
    @ApiModelProperty(value="\u8fd4\u56de\u6570\u636e")
    private T data;

    public static <T> ActionResult<T> success() {
        ActionResult<T> jsonData = new ActionResult<T>();
        jsonData.setCode(200);
        jsonData.setMsg(MsgCode.SU000.get());
        return jsonData;
    }

    public static <T> ActionResult<T> success(String msg) {
        ActionResult<T> jsonData = new ActionResult<T>();
        jsonData.setCode(200);
        jsonData.setMsg(msg);
        return jsonData;
    }

    public static <T> ActionResult<PageListVO<T>> page(List<T> list, PaginationVO pagination) {
        ActionResult jsonData = new ActionResult();
        PageListVO<T> vo = new PageListVO<T>();
        vo.setList(list);
        vo.setPagination(pagination);
        jsonData.setData(vo);
        jsonData.setCode(200);
        jsonData.setMsg(MsgCode.SU000.get());
        return jsonData;
    }

    public static <T> ActionResult<DataInterfacePageListVO<T>> page(List<T> list, PaginationVO pagination, String dataProcessing) {
        ActionResult jsonData = new ActionResult();
        DataInterfacePageListVO<T> vo = new DataInterfacePageListVO<T>();
        vo.setList(list);
        vo.setPagination(pagination);
        vo.setDataProcessing(dataProcessing);
        jsonData.setCode(200);
        jsonData.setData(vo);
        jsonData.setMsg(MsgCode.SU000.get());
        return jsonData;
    }

    public static ActionResult<Object> success(String msg, Object object) {
        ActionResult<Object> jsonData = new ActionResult<Object>();
        jsonData.setData(object);
        jsonData.setCode(200);
        jsonData.setMsg(msg);
        return jsonData;
    }

    public static <T> ActionResult<T> success(T object) {
        ActionResult<T> jsonData = new ActionResult<T>();
        jsonData.setData(object);
        jsonData.setCode(200);
        jsonData.setMsg(MsgCode.SU000.get());
        return jsonData;
    }

    public static <T> ActionResult<T> warning(Integer code, String message) {
        ActionResult<T> jsonData = new ActionResult<T>();
        jsonData.setCode(code);
        jsonData.setMsg(message);
        return jsonData;
    }

    public static ActionResult<String> warning(String msg, String data) {
        ActionResult<String> jsonData = new ActionResult<String>();
        jsonData.setCode(ActionResultCode.Warning.getCode());
        jsonData.setMsg(msg);
        jsonData.setData(data);
        return jsonData;
    }

    public static <T> ActionResult<T> warning(String msg) {
        ActionResult<T> jsonData = new ActionResult<T>();
        jsonData.setCode(ActionResultCode.Warning.getCode());
        jsonData.setMsg(msg);
        return jsonData;
    }

    public static <T> ActionResult<T> fail(Integer code, String message) {
        ActionResult<T> jsonData = new ActionResult<T>();
        jsonData.setCode(code);
        jsonData.setMsg(message);
        return jsonData;
    }

    public static ActionResult<String> fail(String msg, String data) {
        ActionResult<String> jsonData = new ActionResult<String>();
        jsonData.setMsg(msg);
        jsonData.setData(data);
        jsonData.setCode(400);
        return jsonData;
    }

    public static <T> ActionResult<T> fail(String msg) {
        ActionResult<T> jsonData = new ActionResult<T>();
        jsonData.setMsg(msg);
        jsonData.setCode(400);
        return jsonData;
    }

    public static ActionResult<Map<String, Object>> success(Object rows, PageModel pageModel) {
        ActionResult<Map<String, Object>> jsonData = new ActionResult<Map<String, Object>>();
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("page", pageModel.getPage());
        map.put("records", pageModel.getRecords());
        map.put("rows", rows);
        map.put("total", pageModel.getTotal());
        jsonData.setData(map);
        jsonData.setCode(200);
        jsonData.setMsg(MsgCode.SU000.get());
        return jsonData;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public T getData() {
        return this.data;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ActionResult)) {
            return false;
        }
        ActionResult other = (ActionResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$code = this.getCode();
        Integer other$code = other.getCode();
        if (this$code == null ? other$code != null : !((Object)this$code).equals(other$code)) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ActionResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "ActionResult(code=" + this.getCode() + ", msg=" + this.getMsg() + ", data=" + this.getData() + ")";
    }
}

