/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.config;

import com.alibaba.fastjson.JSON;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CachingConfigurerSupport;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.util.DigestUtils;

public class EhcacheConfig
extends CachingConfigurerSupport {
    private static final Logger log = LoggerFactory.getLogger(EhcacheConfig.class);

    public KeyGenerator keyGenerator() {
        return (target, method, params) -> {
            StringBuilder strBuilder = new StringBuilder();
            strBuilder.append(target.getClass().getName());
            strBuilder.append(":");
            strBuilder.append(method.getName());
            for (Object obj : params) {
                if (obj == null) continue;
                strBuilder.append(":");
                strBuilder.append(obj.getClass().getName());
                strBuilder.append(":");
                strBuilder.append(JSON.toJSONString((Object)obj));
            }
            String md5DigestAsHex = DigestUtils.md5DigestAsHex((byte[])strBuilder.toString().getBytes(StandardCharsets.UTF_8));
            log.info("ehcache key md5DigestAsHex: " + md5DigestAsHex);
            return md5DigestAsHex;
        };
    }
}

