/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.database.source.impl;

import com.baomidou.mybatisplus.annotation.DbType;
import com.bringspring.common.database.data.DataSourceContextHolder;
import com.bringspring.common.database.model.dto.DataSourceDTO;
import com.bringspring.common.database.model.interfaces.DataSourceMod;
import com.bringspring.common.database.source.DbBase;
import com.bringspring.common.database.sql.impl.SqlOracle;
import com.bringspring.common.database.util.ConnUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import java.sql.Connection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;

public class DbOracle
extends DbBase {
    private static final String SID_URL = "jdbc:oracle:thin:@{host}:{port}:{schema}";
    private static final String SID_SIGN = "SID";
    private static final String SERVICE_URL = "jdbc:oracle:thin:@//{host}:{port}/{schema}";
    private static final String SERVICE_SIGN = "SERVICE";
    private static final String SCHEMA_URL = "jdbc:oracle:thin:@(DESCRIPTION=(ADDRESS_LIST=(ADDRESS=(PROTOCOL=TCP)(HOST={host})(PORT={port})))(CONNECT_DATA=(SERVICE_NAME={schema})))";
    private static final String SCHEMA_SIGN = "SCHEMA";
    private static final String TNS_URL = "jdbc:oracle:thin:@{schema}";
    private static final String TNS_SIGN = "TNS";
    public static final String ORACLE_SERVICE = "oracleService";
    public static final String ORACLE_LINK_TYPE = "oracleLinkType";
    public static final String ORACLE_ROLE = "oracleRole";

    @Override
    protected void init() {
        this.setInstance("Oracle", DbType.ORACLE, "1521", "oracle", "oracle.jdbc.OracleDriver", "", new SqlOracle());
    }

    public Connection getOracleConn(DataSourceDTO dsd, String url) throws DataException {
        Map<String, Object> oracleParamMap;
        String logonUser = null;
        if (StringUtils.isNotEmpty(dsd.getOracleParam()) && (oracleParamMap = JsonUtil.stringToMap(dsd.getOracleParam())).size() > 0) {
            logonUser = oracleParamMap.get(ORACLE_ROLE).toString();
        }
        return DbOracle.createOracleConn(this.driver, logonUser, dsd.getUserName(), dsd.getPassword(), url);
    }

    @Override
    public String getConnUrl(String prepareUrl, String host, Integer port, String dbName, String schema) {
        Map<String, Object> oracleParamMap;
        if (StringUtils.isNotEmpty(this.getOracleParam()) && StringUtils.isEmpty(prepareUrl) && (oracleParamMap = JsonUtil.stringToMap(this.getOracleParam())).size() > 0) {
            String urlType;
            schema = oracleParamMap.get(ORACLE_SERVICE).toString();
            switch (urlType = oracleParamMap.get(ORACLE_LINK_TYPE).toString()) {
                case "SID": {
                    prepareUrl = SID_URL;
                    break;
                }
                case "SERVICE": {
                    prepareUrl = SERVICE_URL;
                    break;
                }
                case "SCHEMA": {
                    prepareUrl = SCHEMA_URL;
                    break;
                }
                case "TNS": {
                    prepareUrl = TNS_URL;
                    break;
                }
            }
        }
        if (StringUtils.isEmpty(prepareUrl)) {
            prepareUrl = SID_URL;
        }
        return super.getConnUrl(prepareUrl, host, port, dbName, schema);
    }

    @Override
    protected String getDynamicTableName(String tableName) {
        return DataSourceContextHolder.getDatasourceName().toUpperCase() + "." + tableName;
    }

    @Override
    public LinkedList<Object> getStructParams(String structParams, String table, DataSourceMod dbSourceOrDbLink) {
        DataSourceDTO dataSourceDTO = dbSourceOrDbLink.convertDTO();
        dataSourceDTO.setDbName(dataSourceDTO.getUserName());
        return super.getStructParams(structParams, table, dataSourceDTO);
    }

    private static Connection createOracleConn(String driver, String logonUser, String userName, String password, String url) throws DataException {
        Properties conProps = DbOracle.setConnProp(logonUser, userName, password);
        return ConnUtil.ConnCommon.createConnByProp(driver, conProps.getProperty("user"), password, url, conProps);
    }

    public static Properties setConnProp(String logonUser, String userName, String password) {
        Properties conProps = new Properties();
        if (StringUtils.isNotEmpty(logonUser)) {
            conProps.put("defaultRowPrefetch", "15");
            conProps.put("internal_logon", logonUser);
            conProps.put("user", userName);
        }
        conProps.put("user", userName);
        conProps.setProperty("password", password);
        return conProps;
    }
}

