package com.bringspring.common.base;

import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * 登录者信息
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月26日 上午9:18
 */
@Data
public class UserInfo {

    private String code;
    /**
     * 唯一Id
     */
    private String id;
    /**
     * 用户主键
     */
    private String userId;
    /**
     * 用户账户
     */
    private String userAccount;
    /**
     * 用户姓名
     */
    private String userName;

    private String realName;
    /**
     * 用户头像
     */
    private String userIcon;
    /**
     * 用户性别
     */
    private String userGender;
    /**
     * 所在直属公司主键
     */
    private String organizeId;
    /**
     * 所在部门主键
     */
    private String departmentId;
    /**
     * 我的主管
     */
    private String managerId;
    /**
     * 下属机构
     */
    private String[] subOrganizeIds;
    /**
     * 我的下属
     */
    private List<String> subordinateIds;
    /**
     * 岗位主键
     */
    private String[] positionIds;
    /**
     * 角色主键
     */
    private List<String> roleIds;
    /**
     * 登录时间
     */
    private String loginTime;
    /**
     * 登录IP地址
     */
    private String loginIpAddress;
    /**
     * 登录IP地址所在城市
     */
    private String loginIpAddressName;
    /**
     * 登录MAC地址
     */
    private String macAddress;
    /**
     * 登录平台设备
     */
    private String loginPlatForm;
    /**
     * 上次登录时间
     */
    private Date prevLoginTime;
    /**
     * 上次登录IP地址
     */
    private String prevLoginIpAddress;
    /**
     * 上次登录IP地址所在城市
     */
    private String prevLoginIpAddressName;
    /**
     * 是否超级管理员
     */
    private Boolean isAdministrator = false;
    /**
     * 过期时间
     */
    private Date overdueTime;
    /**
     * 系统配置超时时间
     */
    private Integer tokenTimeout;
    /**
     * 租户编码
     */
    private String tenantId;
    public String getTenantId() {
        return tenantId = tenantId == null ? "" : tenantId;
    }
    /**
     * 租户数据库连接串（注意：主要解决多租户系统用的。每个租户连接数据库都是唯一的）
     */
    /**
     * 目前就支持一个数据库。如果业务需要多个数据库，手动去添加 ConnectionString1、ConnectionString2 等等
     */
    private String tenantDbConnectionString;
    /**
     * 租户数据库类型
     */
    private String tenantDbType;
    private String portalId;
}
