package com.bringspring.common.service;



import com.baomidou.mybatisplus.extension.service.IService;
import com.bringspring.common.entity.FileDownLogEntity;
import com.bringspring.common.model.filedownlog.FileDownLogCrForm;
import com.bringspring.common.model.filedownlog.FileDownLogPagination;
import com.bringspring.common.model.filedownlog.FileDownLogUpForm;

import java.util.List;

/**
 * 文件下载日志
 * 版本： V1.0.0
 * 版权： 荣科科技股份有限公司
 * 作者： RKKJ开发平台组
 * 日期： 2025-03-13
 */
public interface FileDownLogService extends IService<FileDownLogEntity> {

    /**
     * 文件下载日志列表分页查询
     *
     * @param filedownlogPagination 查询参数
     * @return List<FiledownlogEntity>
     */
    List<FileDownLogEntity> getList(FileDownLogPagination filedownlogPagination);

    /**
     * 文件下载日志列表分页查询（导出使用）
     *
     * @param filedownlogPagination 查询参数
     * @param dataType              0-当前页；非0-当前查询条件所有数据
     * @return List<FiledownlogEntity>
     */
    List<FileDownLogEntity> getTypeList(FileDownLogPagination filedownlogPagination, String dataType);


    /**
     * 获取文件下载日志详细信息
     *
     * @param id 主键
     * @return FiledownlogEntity
     */
    FileDownLogEntity getInfo(String id);

    /**
     * 删除文件下载日志操作
     *
     * @param entity
     * @return
     */
    void delete(FileDownLogEntity entity);

    /**
     * 创建文件下载日志操作
     *
     * @param filedownlogCrForm 主键
     * @return boolean 是否成功
     */
    void create(FileDownLogCrForm filedownlogCrForm);

    /**
     * 更新文件下载日志操作
     *
     * @param id                主键
     * @param filedownlogUpForm 主键
     * @return boolean 是否成功
     */
    void update(String id, FileDownLogUpForm filedownlogUpForm);


}
