package com.bringspring.common.util.enums;

import com.bringspring.common.util.visiual.JsbosKeyConsts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 数据权限过滤条件字段
 *
 * @author JSBOS开发平台组
 * @version V1.0
 * @copyright 荣科科技
 * @date 2021/10/9
 */
public enum AuthorizeConditionEnum {

    /**
     * 任意文本
     */
    TEXT("input", "任意文本"),
    /**
     * 当前公司
     */
    COMPANY("@companyId", "当前公司"),
    /**
     * 当前组织
     */
    ORGANIZE("@organizeId", "当前组织"),
    /**
     * 当前用户
     */
    USER("@userId", "当前用户"),
    /**
     * 当前用户及下属
     */
    USERANDUNDER("@userAraSubordinates", "当前用户及下属"),
    /**
     * 当前组织及子组织
     */
    ORGANIZEANDUNDER("@organizationAndSuborganization", "当前组织及子组织"),
    /**
     * 当前分管组织
     */
    BRANCHMANAGEORG("@branchManageOrganize", "当前分管组织"),

    /**
     * 当前分管组织及子组织
     */
    BRANCHMANAGEORGANIZEUNDER("@branchManageOrganizeAndSub", "当分管组织及子组织"),


    DATATIME(JsbosKeyConsts.DATE, "日期选择"),
    INPUTNUMBER(JsbosKeyConsts.NUM_INPUT, "数字输入"),
    COMSELECT(JsbosKeyConsts.COMSELECT, "组织选择"),
    DEPSELECT(JsbosKeyConsts.DEPSELECT, "部门选择"),
    POSSELECT(JsbosKeyConsts.POSSELECT, "岗位选择"),
    ROLESELECT(JsbosKeyConsts.ROLESELECT, "角色选择"),
    GROUPSELECT(JsbosKeyConsts.GROUPSELECT, "分组选择"),
    USERSELECT(JsbosKeyConsts.USERSELECT, "用户选择"),
    ADDRESSSELECT(JsbosKeyConsts.ADDRESS, "区划选择"),


    ;
    private String condition;
    private String message;

    AuthorizeConditionEnum(String condition, String message) {
        this.condition = condition;
        this.message = message;
    }

    public String getCondition() {
        return condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public static AuthorizeConditionEnum getByMessage(String condition) {
        for (AuthorizeConditionEnum status : AuthorizeConditionEnum.values()) {
            if (status.getCondition().equals(condition)) {
                return status;
            }
        }
        return null;
    }

    public static List<Map<String, Object>> getConditionOptionsSelect() {
        List<Map<String, Object>> options = new ArrayList<>();
        options.add(new HashMap<String, Object>() {{
            put("value", COMSELECT.getCondition());
            put("label", COMSELECT.getMessage());
        }});
        options.add(new HashMap<String, Object>() {{
            put("value", DEPSELECT.getCondition());
            put("label", DEPSELECT.getMessage());
        }});
        options.add(new HashMap<String, Object>() {{
            put("value", POSSELECT.getCondition());
            put("label", POSSELECT.getMessage());
        }});
        options.add(new HashMap<String, Object>() {{
            put("value", ROLESELECT.getCondition());
            put("label", ROLESELECT.getMessage());
        }});
        options.add(new HashMap<String, Object>() {{
            put("value", GROUPSELECT.getCondition());
            put("label", GROUPSELECT.getMessage());
        }});
        options.add(new HashMap<String, Object>() {{
            put("value", USERSELECT.getCondition());
            put("label", USERSELECT.getMessage());
        }});
        options.add(new HashMap<String, Object>() {{
            put("value", ADDRESSSELECT.getCondition());
            put("label", ADDRESSSELECT.getMessage());
        }});
        return options;
    }
}
