/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.config;

import com.alibaba.fastjson.JSON;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.DigestUtils;

@Configuration
@EnableCaching
public class CacheManagerConfig {
    private static final Logger log = LoggerFactory.getLogger(CacheManagerConfig.class);

    @Bean(value={"cacheKeyGenerator"})
    public KeyGenerator keyGenerator() {
        return (target, method, params) -> {
            StringBuilder strBuilder = new StringBuilder();
            strBuilder.append(target.getClass().getName());
            strBuilder.append(":");
            strBuilder.append(method.getName());
            for (Object obj : params) {
                if (obj == null) continue;
                strBuilder.append(":");
                strBuilder.append(obj.getClass().getName());
                strBuilder.append(":");
                strBuilder.append(JSON.toJSONString((Object)obj));
            }
            String str = strBuilder.toString();
            String md5DigestAsHex = DigestUtils.md5DigestAsHex((byte[])str.getBytes(StandardCharsets.UTF_8));
            return md5DigestAsHex;
        };
    }

    public static interface CacheManagerName {
        public static final String LOCAL_CACHE_MANAGER = "localCacheManager";
        public static final String EHCACHE_CACHE_MAANGER = "ehcacheCacheManager";
        public static final String REDIS_CACHE_MANAGER = "redisCacheManager";
    }
}

