/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.database.sql.append.insert;

import com.bringspring.common.database.model.DataSourceModel;
import com.bringspring.common.database.model.DbFieldMod;
import com.bringspring.common.database.sql.append.insert.InsertSqlDTO;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class InsertSql {
    @Autowired
    DataSourceModel dataSourceModel;

    public static String batch(InsertSqlDTO insertSqlDTO) {
        StringBuilder sql = new StringBuilder();
        for (List<DbFieldMod> data : insertSqlDTO.getDataList()) {
            StringBuilder values = new StringBuilder();
            for (DbFieldMod field : data) {
                String fieldValue = insertSqlDTO.getFieldValue(field.getColumnTypeName(), field.getColumnValue());
                values.append(fieldValue);
            }
            String sqlFragment = insertSqlDTO.getOracleInsertBasicSql() + "(" + values.substring(0, values.length() - 1) + ")" + insertSqlDTO.getBatchInsertSeparator();
            sql.append(sqlFragment);
        }
        return insertSqlDTO.getMysqlInsertBasicSql() + sql;
    }

    public DataSourceModel getDataSourceModel() {
        return this.dataSourceModel;
    }

    public void setDataSourceModel(DataSourceModel dataSourceModel) {
        this.dataSourceModel = dataSourceModel;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InsertSql)) {
            return false;
        }
        InsertSql other = (InsertSql)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DataSourceModel this$dataSourceModel = this.getDataSourceModel();
        DataSourceModel other$dataSourceModel = other.getDataSourceModel();
        return !(this$dataSourceModel == null ? other$dataSourceModel != null : !((Object)this$dataSourceModel).equals(other$dataSourceModel));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InsertSql;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DataSourceModel $dataSourceModel = this.getDataSourceModel();
        result = result * 59 + ($dataSourceModel == null ? 43 : ((Object)$dataSourceModel).hashCode());
        return result;
    }

    public String toString() {
        return "InsertSql(dataSourceModel=" + this.getDataSourceModel() + ")";
    }
}

