/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.util.jscript;

import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class JScriptUtil {
    public static final String JSCONTENT = "var method = function(data) {${jsContent}};var result = method(JSON.parse('${data}'));JSON.stringify(result);";

    public static Object callJs(String script) throws ScriptException {
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        ScriptEngine scriptEngine = scriptEngineManager.getEngineByName("js");
        return scriptEngine.eval(script);
    }

    public static Object callJs(String dataProcessing, Object data) throws ScriptException {
        String jsContent = JScriptUtil.getJsContent(dataProcessing);
        if (StringUtils.isEmpty(dataProcessing)) {
            return data;
        }
        String replace = JSCONTENT.replace("${jsContent}", jsContent);
        replace = replace.replace("${data}", JsonUtil.getObjectToString(data));
        Object result = JScriptUtil.callJs(replace);
        try {
            List<Map<String, Object>> jsonToListMap = JsonUtil.getJsonToListMap(result.toString());
            return jsonToListMap;
        }
        catch (Exception e) {
            try {
                Map<String, Object> map = JsonUtil.stringToMap(result.toString());
                return map;
            }
            catch (Exception json) {
                return result.toString().replace("\"", "");
            }
        }
    }

    public static String getJsContent(String dataProcessing) {
        if (StringUtils.isNotEmpty(dataProcessing) && dataProcessing.length() > 0) {
            int lastIndexOf;
            int indexOf = dataProcessing.indexOf("{");
            if (indexOf > -1) {
                dataProcessing = dataProcessing.substring(indexOf + 1);
            }
            if ((lastIndexOf = dataProcessing.lastIndexOf("}")) > -1) {
                dataProcessing = dataProcessing.substring(0, lastIndexOf);
            }
            return dataProcessing;
        }
        return "";
    }
}

