package com.bringspring.common.database.enums;

import com.bringspring.common.database.source.DbBase;
import com.bringspring.common.database.source.impl.DbOracle;
import com.bringspring.common.database.source.impl.DbPostgre;

/**
 * 别名枚举
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/6/29
 */
public enum DbAliasEnum {

    /**
     * 允空
     * 允许：1，不允许：0
     */
    ALLOW_NULL("ALLOW_NULL") {
        @Override
        public Integer isTrue() {
            return 1;
        }

        @Override
        public Integer isFalse() {
            return 0;
        }
    },
    /**
     * 主键
     * 存在：1，不存在：0
     */
    PRIMARY_KEY("PRIMARY_KEY") {
        @Override
        public Integer isTrue() {
            return 1;
        }

        @Override
        public Integer isFalse() {
            return 0;
        }
    },
    /**
     * 总数返回
     */
    TOTAL_RECORD("totalRecord");


    public Integer isTrue() {
        return null;
    }

    public Integer isFalse() {
        return null;
    }

    private final String alias;

    DbAliasEnum(String alias) {
        this.alias = alias;
    }

    public String AS() {
        return alias;
    }

    public String asByDb(DbBase db) {
        if (DbPostgre.class.equals(db.getClass())) {
            //postgre别名只能输出小写，Oracle只能大写
            //Mysql默认，SqlServer默认
            return alias.toLowerCase();
        } else if (DbOracle.class.equals(db.getClass())) {
            return alias.toUpperCase();
        } else {
            return alias;
        }
    }

    public static String getAsByDb(DbBase db, String keyWord) {
        if (DbPostgre.class.equals(db.getClass())) {
            //postgre别名只能输出小写，Oracle只能大写
            //Mysql默认，SqlServer默认
            return keyWord.toLowerCase();
        } else if (DbOracle.class.equals(db.getClass())) {
            return keyWord.toUpperCase();
        } else {
            return keyWord;
        }
    }

}
