package com.bringspring.common.filter;

import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

import java.util.ArrayList;
import java.util.List;

/**
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/3/16 9:00
 */
@Configuration
public class WebFilterConfig implements WebMvcConfigurer {

    @Override
    public void addViewControllers(ViewControllerRegistry registry) {
        // 默认首页配置
        registry.addViewController("/mobile/").setViewName("forward:/mobile/index.html");
    }

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        //注册重复请求拦截器
        registry.addInterceptor(new RepeatSubmitRule());
        //注册TestInterceptor拦截器
        InterceptorRegistration registration = registry.addInterceptor(new TokenInterceptor());
        //不拦截的路径
        registration.excludePathPatterns(excludePath());
    }
    private List<String> excludePath() {
        List<String> list = new ArrayList<>();

        list.add("/rlogin");
        list.add("/web/**");
        list.add("/api/service/**");
        list.add("/api/white/**");
        //智能体放开
        list.add("/mcp/**");
        list.add("/api/oauth/Login");
        list.add("/api/oauth/LogingByQy");
        list.add("/api/oauth/getUserIdByCode");
        list.add("/api/oauth/getFile");
        list.add("/api/app/Version");
        list.add("/api/file/Uploader/**");
//        list.add("/api/file/Download/**");
        list.add("/api/visualdev/Generater/DownloadVisCode/**");
        list.add("/api/file/DownloadModel/**");
        list.add("/api/file/Image/**");
        list.add("/api/file/ImageCode/**");
        list.add("/api/extend/DocumentPreview/**");
        list.add("/api/extend/Document/getShareEntityById/{id}");
        list.add("/api/visualdev/DataScreen/Images/**");
        list.add("/api/extend/DocumentPreview/down/{fileName}");
        list.add("/api/system/DataMap/**");
//        list.add("/api/file/**");
//        list.add("/api/file/onlinePreview");
//        list.add("/api/file/onlinePreview");
        //大屏图片
//        list.add("/api/file/VisusalImg/**");
        list.add("/api/blade-visual/map/data");
        list.add("/api/blade-visual/category/list");
        list.add("/api/blade-visual/visual/put-file/**");
        list.add("/api/blade-visual/visual/put-file/**");
        //避免拦截/websocket链接
        list.add("/message/websocket");
        list.add("/api/system/DictionaryData/{dictionaryTypeId}/Data/Selector");
        list.add("/swagger-ui/**");
        list.add("/swagger-ui/index.html");
        list.add("/swagger-resources/**");
        list.add("/webjars/**");
        list.add("/v3/**");
        list.add("/api/system/DataMap/{id}/Data");
        list.add("/api/system/DataInterface/{id}/Actions/Response");
        list.add("/api/oauth/ImageCode/{codeLength}/{timestamp}");
        list.add("/api/oauth/SmsCode/**");
        list.add("/api/oauth/register");
        list.add("/api/oauth/getConfig/{account}");
        list.add("/api/oauth/getQyhConfig");
        list.add("/api/oauth/getSystemAddress/{terminal}");
        list.add("/api/system/Menu/systemList");
        /**
         * 放开前端页面静态文件
         */
        list.add("/mobile/**");

        list.add("/");
        list.add("/static/**");
        list.add("/cdn/**");
        list.add("/*.icon");
        list.add("/*.js");
        list.add("/index.html");
        return list;
    }

}
