package com.bringspring.common.model.filedownlog;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

/**
 * @版本： V1.0.0
 * @版权： 荣科科技股份有限公司
 * @作者： RKKJ开发平台组
 * @日期： 2025-03-13
 */
@Data
public class FileDownLogInfoVO {
    /**
     * 主键
     **/
    @JsonProperty("id")
    private String id;

    /**
     * 存储引擎
     **/
    @JsonProperty("engine")
    private String engine;

    /**
     * 存储桶
     **/
    @JsonProperty("bucket")
    private String bucket;

    /**
     * 文件id
     **/
    @JsonProperty("file_id")
    private String file_id;

    /**
     * 文件名称
     **/
    @JsonProperty("file_name")
    private String file_name;

    /**
     * 文件后缀
     **/
    @JsonProperty("suffix")
    private String suffix;

    /**
     * 文件大小
     **/
    @JsonProperty("size_info")
    private String size_info;

    /**
     * 文件的对象名（唯一名称）
     **/
    @JsonProperty("obj_name")
    private String obj_name;

    /**
     * 文件存储路径
     **/
    @JsonProperty("storage_path")
    private String storage_path;

    /**
     * 文件二级存储路径
     **/
    @JsonProperty("second_file_path")
    private String second_file_path;

    /**
     * 图片缩略图
     **/
    @JsonProperty("thumbnail")
    private String thumbnail;

    /**
     * 文件版本
     **/
    @JsonProperty("file_version")
    private String file_version;

    /**
     * 文件一级存储路径
     **/
    @JsonProperty("file_type")
    private String file_type;

    /**
     * 上传方式
     **/
    @JsonProperty("type")
    private String type;

    /**
     * 下载链接
     **/
    @JsonProperty("url")
    private String url;

    /**
     * 模块类型/业务类型
     **/
    @JsonProperty("modular")
    private String modular;

    /**
     * 业务id
     **/
    @JsonProperty("business_id")
    private String business_id;

    /**
     * 文件MD5
     **/
    @JsonProperty("file_digest")
    private String file_digest;

    /**
     * 单行输入
     **/
    @JsonProperty("old_file_version_id")
    private String old_file_version_id;

}