/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.config;

import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.XSSEscape;
import java.io.File;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="config")
public class ConfigValueUtil {
    @Value(value="${config.Path}")
    private String path;
    private String licenseFilePath;
    private String dataBackupFilePath;
    private String temporaryFilePath;
    private String systemFilePath;
    private String templateFilePath;
    private String templateCodePath;
    private String emailFilePath;
    private String biVisualPath;
    private String documentFilePath;
    private String documentZip;
    private String documentPreviewPath;
    private String userAvatarFilePath;
    private String imContentFilePath;
    @Value(value="${config.fileType}")
    private String fileType;
    private String documentEcbp;
    private String iotAnalysisPath;
    @Value(value="${config.AllowUploadFileType:jpg,gif,png,bmp,jpeg,doc,docx,ppt,pptx,xls,xlsx,pdf,txt,rar,zip,csv,mp3}")
    private String allowUploadFileType;
    @Value(value="${config.AllowUploadImageType:jpg,gif,png,bmp,jpeg,tiff,psd,swf,svg,pcx,dxf,wmf,emf,lic,eps,tga}")
    private String allowUploadImageType;
    @Value(value="${config.AllowPreviewFileType:doc,docx,xls,xlsx,ppt,pptx,pdf,txt}")
    private String allowPreviewFileType;
    @Value(value="${config.PreviewType:kkfile}")
    private String previewType;
    @Value(value="${config.kkFileUrl:}")
    private String kkFileUrl;
    private String serviceDirectoryPath;
    @Value(value="${config.CodeAreasName}")
    private String codeAreasName;
    private String webAnnexFilePath;
    private String ecsOriginalFilePath;
    private String ecsReimbursementFilePath;
    @Value(value="${config.EnablePreAuth:false}")
    private Boolean enablePreAuth;
    @Value(value="${config.ErrorReport}")
    private String errorReport;
    @Value(value="${config.ErrorReportTo}")
    private String errorReportTo;
    @Value(value="${config.RecordLog}")
    private String recordLog;
    @Value(value="${config.MultiTenancy}")
    private String multiTenancy;
    @Value(value="${config.SoftVersion}")
    private String softVersion;
    @Value(value="${config.IgexinEnabled}")
    private String igexinEnabled;
    @Value(value="${config.IgexinAppid}")
    private String igexinAppid;
    @Value(value="${config.IgexinAppkey}")
    private String igexinAppkey;
    @Value(value="${config.IgexinMastersecret}")
    private String igexinMastersecret;
    @Value(value="${config.AppUpdateContent}")
    private String appUpdateContent;
    @Value(value="${config.AppVersion}")
    private String appVersion;
    @Value(value="${config.TestVersion:false}")
    private String testVersion;

    public String getServiceDirectoryPath() {
        String folder = StringUtils.isNotEmpty(this.serviceDirectoryPath) ? this.serviceDirectoryPath : "CodeTemp";
        return this.getXssPath(this.path + folder + File.separator);
    }

    public String getLicenseFilePath() {
        String folder = StringUtils.isNotEmpty(this.licenseFilePath) ? this.licenseFilePath : "License";
        return this.getXssPath(this.path + folder + File.separator);
    }

    public String getDataBackupFilePath() {
        String folder = StringUtils.isNotEmpty(this.dataBackupFilePath) ? this.dataBackupFilePath : "DataBackupFile";
        return this.getXssPath(this.path + folder + File.separator);
    }

    public String getDocumentEcbpFilePath() {
        String folder = StringUtils.isNotEmpty(this.documentEcbp) ? this.documentEcbp : "DocumentEcbp";
        return this.getXssPath(this.path + folder + File.separator);
    }

    public String getIotAnalysisFilePath() {
        String folder = StringUtils.isNotEmpty(this.iotAnalysisPath) ? this.iotAnalysisPath : "iotAnalysis";
        return this.getXssPath(this.path + folder + File.separator);
    }

    public String getTemporaryFilePath() {
        String folder = StringUtils.isNotEmpty(this.temporaryFilePath) ? this.temporaryFilePath : "TemporaryFile";
        return this.getXssPath(this.path + folder + File.separator);
    }

    public String getSystemFilePath() {
        String folder = StringUtils.isNotEmpty(this.systemFilePath) ? this.systemFilePath : "SystemFile";
        return this.getXssPath(this.path + folder + File.separator);
    }

    public String getTemplateFilePath() {
        String folder = StringUtils.isNotEmpty(this.templateFilePath) ? this.templateFilePath : "TemplateFile";
        return this.getXssPath(this.path + folder + File.separator);
    }

    public String getTemplateCodePath() {
        String folder = StringUtils.isNotEmpty(this.templateCodePath) ? this.templateCodePath : "TemplateCode";
        return this.getXssPath(this.path + folder + File.separator);
    }

    public String getEmailFilePath() {
        String folder = StringUtils.isNotEmpty(this.emailFilePath) ? this.emailFilePath : "EmailFile";
        return this.getXssPath(this.path + folder + File.separator);
    }

    public String getDocumentPreviewPath() {
        String folder = StringUtils.isNotEmpty(this.documentPreviewPath) ? this.documentPreviewPath : "DocumentPreview";
        return this.getXssPath(this.path + folder + File.separator);
    }

    public String getUserAvatarFilePath() {
        String folder = StringUtils.isNotEmpty(this.userAvatarFilePath) ? this.userAvatarFilePath : "UserAvatar";
        return this.getXssPath(this.path + folder + File.separator);
    }

    public String getImContentFilePath() {
        String folder = StringUtils.isNotEmpty(this.imContentFilePath) ? this.imContentFilePath : "IMContentFile";
        return this.getXssPath(this.path + folder + File.separator);
    }

    public String getDocumentFilePath() {
        String folder = StringUtils.isNotEmpty(this.documentFilePath) ? this.documentFilePath : "DocumentFile";
        return this.getXssPath(this.path + folder + File.separator);
    }

    public String getDocumentZip() {
        String folder = StringUtils.isNotEmpty(this.documentZip) ? this.documentZip : "DocumentFile" + File.separator + "temporaryZip";
        return this.getXssPath(this.path + folder + File.separator);
    }

    public String getWebAnnexFilePath() {
        String folder = StringUtils.isNotEmpty(this.webAnnexFilePath) ? this.webAnnexFilePath : "WebAnnexFile";
        return this.getXssPath(this.path + folder + File.separator);
    }

    public String getEcsOriginalFilePath() {
        String folder = StringUtils.isNotEmpty(this.ecsOriginalFilePath) ? this.ecsOriginalFilePath : "EcsOriginalFile";
        return this.getXssPath(this.path + folder + File.separator);
    }

    public String getEcsReimbursementFilePath() {
        String folder = StringUtils.isNotEmpty(this.ecsReimbursementFilePath) ? this.ecsReimbursementFilePath : "EcsReimbursementFile";
        return this.getXssPath(this.path + folder + File.separator);
    }

    public String getBiVisualPath() {
        String folder = StringUtils.isNotEmpty(this.biVisualPath) ? this.biVisualPath : "BiVisualPath";
        return this.getXssPath(this.path + folder + File.separator);
    }

    private String getXssPath(String path) {
        String xssPath = XSSEscape.escapePath(path);
        return xssPath;
    }

    public String getPath() {
        return this.path;
    }

    public String getFileType() {
        return this.fileType;
    }

    public String getDocumentEcbp() {
        return this.documentEcbp;
    }

    public String getIotAnalysisPath() {
        return this.iotAnalysisPath;
    }

    public String getAllowUploadFileType() {
        return this.allowUploadFileType;
    }

    public String getAllowUploadImageType() {
        return this.allowUploadImageType;
    }

    public String getAllowPreviewFileType() {
        return this.allowPreviewFileType;
    }

    public String getPreviewType() {
        return this.previewType;
    }

    public String getKkFileUrl() {
        return this.kkFileUrl;
    }

    public String getCodeAreasName() {
        return this.codeAreasName;
    }

    public Boolean getEnablePreAuth() {
        return this.enablePreAuth;
    }

    public String getErrorReport() {
        return this.errorReport;
    }

    public String getErrorReportTo() {
        return this.errorReportTo;
    }

    public String getRecordLog() {
        return this.recordLog;
    }

    public String getMultiTenancy() {
        return this.multiTenancy;
    }

    public String getSoftVersion() {
        return this.softVersion;
    }

    public String getIgexinEnabled() {
        return this.igexinEnabled;
    }

    public String getIgexinAppid() {
        return this.igexinAppid;
    }

    public String getIgexinAppkey() {
        return this.igexinAppkey;
    }

    public String getIgexinMastersecret() {
        return this.igexinMastersecret;
    }

    public String getAppUpdateContent() {
        return this.appUpdateContent;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public String getTestVersion() {
        return this.testVersion;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setLicenseFilePath(String licenseFilePath) {
        this.licenseFilePath = licenseFilePath;
    }

    public void setDataBackupFilePath(String dataBackupFilePath) {
        this.dataBackupFilePath = dataBackupFilePath;
    }

    public void setTemporaryFilePath(String temporaryFilePath) {
        this.temporaryFilePath = temporaryFilePath;
    }

    public void setSystemFilePath(String systemFilePath) {
        this.systemFilePath = systemFilePath;
    }

    public void setTemplateFilePath(String templateFilePath) {
        this.templateFilePath = templateFilePath;
    }

    public void setTemplateCodePath(String templateCodePath) {
        this.templateCodePath = templateCodePath;
    }

    public void setEmailFilePath(String emailFilePath) {
        this.emailFilePath = emailFilePath;
    }

    public void setBiVisualPath(String biVisualPath) {
        this.biVisualPath = biVisualPath;
    }

    public void setDocumentFilePath(String documentFilePath) {
        this.documentFilePath = documentFilePath;
    }

    public void setDocumentZip(String documentZip) {
        this.documentZip = documentZip;
    }

    public void setDocumentPreviewPath(String documentPreviewPath) {
        this.documentPreviewPath = documentPreviewPath;
    }

    public void setUserAvatarFilePath(String userAvatarFilePath) {
        this.userAvatarFilePath = userAvatarFilePath;
    }

    public void setImContentFilePath(String imContentFilePath) {
        this.imContentFilePath = imContentFilePath;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public void setDocumentEcbp(String documentEcbp) {
        this.documentEcbp = documentEcbp;
    }

    public void setIotAnalysisPath(String iotAnalysisPath) {
        this.iotAnalysisPath = iotAnalysisPath;
    }

    public void setAllowUploadFileType(String allowUploadFileType) {
        this.allowUploadFileType = allowUploadFileType;
    }

    public void setAllowUploadImageType(String allowUploadImageType) {
        this.allowUploadImageType = allowUploadImageType;
    }

    public void setAllowPreviewFileType(String allowPreviewFileType) {
        this.allowPreviewFileType = allowPreviewFileType;
    }

    public void setPreviewType(String previewType) {
        this.previewType = previewType;
    }

    public void setKkFileUrl(String kkFileUrl) {
        this.kkFileUrl = kkFileUrl;
    }

    public void setServiceDirectoryPath(String serviceDirectoryPath) {
        this.serviceDirectoryPath = serviceDirectoryPath;
    }

    public void setCodeAreasName(String codeAreasName) {
        this.codeAreasName = codeAreasName;
    }

    public void setWebAnnexFilePath(String webAnnexFilePath) {
        this.webAnnexFilePath = webAnnexFilePath;
    }

    public void setEcsOriginalFilePath(String ecsOriginalFilePath) {
        this.ecsOriginalFilePath = ecsOriginalFilePath;
    }

    public void setEcsReimbursementFilePath(String ecsReimbursementFilePath) {
        this.ecsReimbursementFilePath = ecsReimbursementFilePath;
    }

    public void setEnablePreAuth(Boolean enablePreAuth) {
        this.enablePreAuth = enablePreAuth;
    }

    public void setErrorReport(String errorReport) {
        this.errorReport = errorReport;
    }

    public void setErrorReportTo(String errorReportTo) {
        this.errorReportTo = errorReportTo;
    }

    public void setRecordLog(String recordLog) {
        this.recordLog = recordLog;
    }

    public void setMultiTenancy(String multiTenancy) {
        this.multiTenancy = multiTenancy;
    }

    public void setSoftVersion(String softVersion) {
        this.softVersion = softVersion;
    }

    public void setIgexinEnabled(String igexinEnabled) {
        this.igexinEnabled = igexinEnabled;
    }

    public void setIgexinAppid(String igexinAppid) {
        this.igexinAppid = igexinAppid;
    }

    public void setIgexinAppkey(String igexinAppkey) {
        this.igexinAppkey = igexinAppkey;
    }

    public void setIgexinMastersecret(String igexinMastersecret) {
        this.igexinMastersecret = igexinMastersecret;
    }

    public void setAppUpdateContent(String appUpdateContent) {
        this.appUpdateContent = appUpdateContent;
    }

    public void setAppVersion(String appVersion) {
        this.appVersion = appVersion;
    }

    public void setTestVersion(String testVersion) {
        this.testVersion = testVersion;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConfigValueUtil)) {
            return false;
        }
        ConfigValueUtil other = (ConfigValueUtil)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$enablePreAuth = this.getEnablePreAuth();
        Boolean other$enablePreAuth = other.getEnablePreAuth();
        if (this$enablePreAuth == null ? other$enablePreAuth != null : !((Object)this$enablePreAuth).equals(other$enablePreAuth)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        String this$licenseFilePath = this.getLicenseFilePath();
        String other$licenseFilePath = other.getLicenseFilePath();
        if (this$licenseFilePath == null ? other$licenseFilePath != null : !this$licenseFilePath.equals(other$licenseFilePath)) {
            return false;
        }
        String this$dataBackupFilePath = this.getDataBackupFilePath();
        String other$dataBackupFilePath = other.getDataBackupFilePath();
        if (this$dataBackupFilePath == null ? other$dataBackupFilePath != null : !this$dataBackupFilePath.equals(other$dataBackupFilePath)) {
            return false;
        }
        String this$temporaryFilePath = this.getTemporaryFilePath();
        String other$temporaryFilePath = other.getTemporaryFilePath();
        if (this$temporaryFilePath == null ? other$temporaryFilePath != null : !this$temporaryFilePath.equals(other$temporaryFilePath)) {
            return false;
        }
        String this$systemFilePath = this.getSystemFilePath();
        String other$systemFilePath = other.getSystemFilePath();
        if (this$systemFilePath == null ? other$systemFilePath != null : !this$systemFilePath.equals(other$systemFilePath)) {
            return false;
        }
        String this$templateFilePath = this.getTemplateFilePath();
        String other$templateFilePath = other.getTemplateFilePath();
        if (this$templateFilePath == null ? other$templateFilePath != null : !this$templateFilePath.equals(other$templateFilePath)) {
            return false;
        }
        String this$templateCodePath = this.getTemplateCodePath();
        String other$templateCodePath = other.getTemplateCodePath();
        if (this$templateCodePath == null ? other$templateCodePath != null : !this$templateCodePath.equals(other$templateCodePath)) {
            return false;
        }
        String this$emailFilePath = this.getEmailFilePath();
        String other$emailFilePath = other.getEmailFilePath();
        if (this$emailFilePath == null ? other$emailFilePath != null : !this$emailFilePath.equals(other$emailFilePath)) {
            return false;
        }
        String this$biVisualPath = this.getBiVisualPath();
        String other$biVisualPath = other.getBiVisualPath();
        if (this$biVisualPath == null ? other$biVisualPath != null : !this$biVisualPath.equals(other$biVisualPath)) {
            return false;
        }
        String this$documentFilePath = this.getDocumentFilePath();
        String other$documentFilePath = other.getDocumentFilePath();
        if (this$documentFilePath == null ? other$documentFilePath != null : !this$documentFilePath.equals(other$documentFilePath)) {
            return false;
        }
        String this$documentZip = this.getDocumentZip();
        String other$documentZip = other.getDocumentZip();
        if (this$documentZip == null ? other$documentZip != null : !this$documentZip.equals(other$documentZip)) {
            return false;
        }
        String this$documentPreviewPath = this.getDocumentPreviewPath();
        String other$documentPreviewPath = other.getDocumentPreviewPath();
        if (this$documentPreviewPath == null ? other$documentPreviewPath != null : !this$documentPreviewPath.equals(other$documentPreviewPath)) {
            return false;
        }
        String this$userAvatarFilePath = this.getUserAvatarFilePath();
        String other$userAvatarFilePath = other.getUserAvatarFilePath();
        if (this$userAvatarFilePath == null ? other$userAvatarFilePath != null : !this$userAvatarFilePath.equals(other$userAvatarFilePath)) {
            return false;
        }
        String this$imContentFilePath = this.getImContentFilePath();
        String other$imContentFilePath = other.getImContentFilePath();
        if (this$imContentFilePath == null ? other$imContentFilePath != null : !this$imContentFilePath.equals(other$imContentFilePath)) {
            return false;
        }
        String this$fileType = this.getFileType();
        String other$fileType = other.getFileType();
        if (this$fileType == null ? other$fileType != null : !this$fileType.equals(other$fileType)) {
            return false;
        }
        String this$documentEcbp = this.getDocumentEcbp();
        String other$documentEcbp = other.getDocumentEcbp();
        if (this$documentEcbp == null ? other$documentEcbp != null : !this$documentEcbp.equals(other$documentEcbp)) {
            return false;
        }
        String this$iotAnalysisPath = this.getIotAnalysisPath();
        String other$iotAnalysisPath = other.getIotAnalysisPath();
        if (this$iotAnalysisPath == null ? other$iotAnalysisPath != null : !this$iotAnalysisPath.equals(other$iotAnalysisPath)) {
            return false;
        }
        String this$allowUploadFileType = this.getAllowUploadFileType();
        String other$allowUploadFileType = other.getAllowUploadFileType();
        if (this$allowUploadFileType == null ? other$allowUploadFileType != null : !this$allowUploadFileType.equals(other$allowUploadFileType)) {
            return false;
        }
        String this$allowUploadImageType = this.getAllowUploadImageType();
        String other$allowUploadImageType = other.getAllowUploadImageType();
        if (this$allowUploadImageType == null ? other$allowUploadImageType != null : !this$allowUploadImageType.equals(other$allowUploadImageType)) {
            return false;
        }
        String this$allowPreviewFileType = this.getAllowPreviewFileType();
        String other$allowPreviewFileType = other.getAllowPreviewFileType();
        if (this$allowPreviewFileType == null ? other$allowPreviewFileType != null : !this$allowPreviewFileType.equals(other$allowPreviewFileType)) {
            return false;
        }
        String this$previewType = this.getPreviewType();
        String other$previewType = other.getPreviewType();
        if (this$previewType == null ? other$previewType != null : !this$previewType.equals(other$previewType)) {
            return false;
        }
        String this$kkFileUrl = this.getKkFileUrl();
        String other$kkFileUrl = other.getKkFileUrl();
        if (this$kkFileUrl == null ? other$kkFileUrl != null : !this$kkFileUrl.equals(other$kkFileUrl)) {
            return false;
        }
        String this$serviceDirectoryPath = this.getServiceDirectoryPath();
        String other$serviceDirectoryPath = other.getServiceDirectoryPath();
        if (this$serviceDirectoryPath == null ? other$serviceDirectoryPath != null : !this$serviceDirectoryPath.equals(other$serviceDirectoryPath)) {
            return false;
        }
        String this$codeAreasName = this.getCodeAreasName();
        String other$codeAreasName = other.getCodeAreasName();
        if (this$codeAreasName == null ? other$codeAreasName != null : !this$codeAreasName.equals(other$codeAreasName)) {
            return false;
        }
        String this$webAnnexFilePath = this.getWebAnnexFilePath();
        String other$webAnnexFilePath = other.getWebAnnexFilePath();
        if (this$webAnnexFilePath == null ? other$webAnnexFilePath != null : !this$webAnnexFilePath.equals(other$webAnnexFilePath)) {
            return false;
        }
        String this$ecsOriginalFilePath = this.getEcsOriginalFilePath();
        String other$ecsOriginalFilePath = other.getEcsOriginalFilePath();
        if (this$ecsOriginalFilePath == null ? other$ecsOriginalFilePath != null : !this$ecsOriginalFilePath.equals(other$ecsOriginalFilePath)) {
            return false;
        }
        String this$ecsReimbursementFilePath = this.getEcsReimbursementFilePath();
        String other$ecsReimbursementFilePath = other.getEcsReimbursementFilePath();
        if (this$ecsReimbursementFilePath == null ? other$ecsReimbursementFilePath != null : !this$ecsReimbursementFilePath.equals(other$ecsReimbursementFilePath)) {
            return false;
        }
        String this$errorReport = this.getErrorReport();
        String other$errorReport = other.getErrorReport();
        if (this$errorReport == null ? other$errorReport != null : !this$errorReport.equals(other$errorReport)) {
            return false;
        }
        String this$errorReportTo = this.getErrorReportTo();
        String other$errorReportTo = other.getErrorReportTo();
        if (this$errorReportTo == null ? other$errorReportTo != null : !this$errorReportTo.equals(other$errorReportTo)) {
            return false;
        }
        String this$recordLog = this.getRecordLog();
        String other$recordLog = other.getRecordLog();
        if (this$recordLog == null ? other$recordLog != null : !this$recordLog.equals(other$recordLog)) {
            return false;
        }
        String this$multiTenancy = this.getMultiTenancy();
        String other$multiTenancy = other.getMultiTenancy();
        if (this$multiTenancy == null ? other$multiTenancy != null : !this$multiTenancy.equals(other$multiTenancy)) {
            return false;
        }
        String this$softVersion = this.getSoftVersion();
        String other$softVersion = other.getSoftVersion();
        if (this$softVersion == null ? other$softVersion != null : !this$softVersion.equals(other$softVersion)) {
            return false;
        }
        String this$igexinEnabled = this.getIgexinEnabled();
        String other$igexinEnabled = other.getIgexinEnabled();
        if (this$igexinEnabled == null ? other$igexinEnabled != null : !this$igexinEnabled.equals(other$igexinEnabled)) {
            return false;
        }
        String this$igexinAppid = this.getIgexinAppid();
        String other$igexinAppid = other.getIgexinAppid();
        if (this$igexinAppid == null ? other$igexinAppid != null : !this$igexinAppid.equals(other$igexinAppid)) {
            return false;
        }
        String this$igexinAppkey = this.getIgexinAppkey();
        String other$igexinAppkey = other.getIgexinAppkey();
        if (this$igexinAppkey == null ? other$igexinAppkey != null : !this$igexinAppkey.equals(other$igexinAppkey)) {
            return false;
        }
        String this$igexinMastersecret = this.getIgexinMastersecret();
        String other$igexinMastersecret = other.getIgexinMastersecret();
        if (this$igexinMastersecret == null ? other$igexinMastersecret != null : !this$igexinMastersecret.equals(other$igexinMastersecret)) {
            return false;
        }
        String this$appUpdateContent = this.getAppUpdateContent();
        String other$appUpdateContent = other.getAppUpdateContent();
        if (this$appUpdateContent == null ? other$appUpdateContent != null : !this$appUpdateContent.equals(other$appUpdateContent)) {
            return false;
        }
        String this$appVersion = this.getAppVersion();
        String other$appVersion = other.getAppVersion();
        if (this$appVersion == null ? other$appVersion != null : !this$appVersion.equals(other$appVersion)) {
            return false;
        }
        String this$testVersion = this.getTestVersion();
        String other$testVersion = other.getTestVersion();
        return !(this$testVersion == null ? other$testVersion != null : !this$testVersion.equals(other$testVersion));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConfigValueUtil;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $enablePreAuth = this.getEnablePreAuth();
        result = result * 59 + ($enablePreAuth == null ? 43 : ((Object)$enablePreAuth).hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        String $licenseFilePath = this.getLicenseFilePath();
        result = result * 59 + ($licenseFilePath == null ? 43 : $licenseFilePath.hashCode());
        String $dataBackupFilePath = this.getDataBackupFilePath();
        result = result * 59 + ($dataBackupFilePath == null ? 43 : $dataBackupFilePath.hashCode());
        String $temporaryFilePath = this.getTemporaryFilePath();
        result = result * 59 + ($temporaryFilePath == null ? 43 : $temporaryFilePath.hashCode());
        String $systemFilePath = this.getSystemFilePath();
        result = result * 59 + ($systemFilePath == null ? 43 : $systemFilePath.hashCode());
        String $templateFilePath = this.getTemplateFilePath();
        result = result * 59 + ($templateFilePath == null ? 43 : $templateFilePath.hashCode());
        String $templateCodePath = this.getTemplateCodePath();
        result = result * 59 + ($templateCodePath == null ? 43 : $templateCodePath.hashCode());
        String $emailFilePath = this.getEmailFilePath();
        result = result * 59 + ($emailFilePath == null ? 43 : $emailFilePath.hashCode());
        String $biVisualPath = this.getBiVisualPath();
        result = result * 59 + ($biVisualPath == null ? 43 : $biVisualPath.hashCode());
        String $documentFilePath = this.getDocumentFilePath();
        result = result * 59 + ($documentFilePath == null ? 43 : $documentFilePath.hashCode());
        String $documentZip = this.getDocumentZip();
        result = result * 59 + ($documentZip == null ? 43 : $documentZip.hashCode());
        String $documentPreviewPath = this.getDocumentPreviewPath();
        result = result * 59 + ($documentPreviewPath == null ? 43 : $documentPreviewPath.hashCode());
        String $userAvatarFilePath = this.getUserAvatarFilePath();
        result = result * 59 + ($userAvatarFilePath == null ? 43 : $userAvatarFilePath.hashCode());
        String $imContentFilePath = this.getImContentFilePath();
        result = result * 59 + ($imContentFilePath == null ? 43 : $imContentFilePath.hashCode());
        String $fileType = this.getFileType();
        result = result * 59 + ($fileType == null ? 43 : $fileType.hashCode());
        String $documentEcbp = this.getDocumentEcbp();
        result = result * 59 + ($documentEcbp == null ? 43 : $documentEcbp.hashCode());
        String $iotAnalysisPath = this.getIotAnalysisPath();
        result = result * 59 + ($iotAnalysisPath == null ? 43 : $iotAnalysisPath.hashCode());
        String $allowUploadFileType = this.getAllowUploadFileType();
        result = result * 59 + ($allowUploadFileType == null ? 43 : $allowUploadFileType.hashCode());
        String $allowUploadImageType = this.getAllowUploadImageType();
        result = result * 59 + ($allowUploadImageType == null ? 43 : $allowUploadImageType.hashCode());
        String $allowPreviewFileType = this.getAllowPreviewFileType();
        result = result * 59 + ($allowPreviewFileType == null ? 43 : $allowPreviewFileType.hashCode());
        String $previewType = this.getPreviewType();
        result = result * 59 + ($previewType == null ? 43 : $previewType.hashCode());
        String $kkFileUrl = this.getKkFileUrl();
        result = result * 59 + ($kkFileUrl == null ? 43 : $kkFileUrl.hashCode());
        String $serviceDirectoryPath = this.getServiceDirectoryPath();
        result = result * 59 + ($serviceDirectoryPath == null ? 43 : $serviceDirectoryPath.hashCode());
        String $codeAreasName = this.getCodeAreasName();
        result = result * 59 + ($codeAreasName == null ? 43 : $codeAreasName.hashCode());
        String $webAnnexFilePath = this.getWebAnnexFilePath();
        result = result * 59 + ($webAnnexFilePath == null ? 43 : $webAnnexFilePath.hashCode());
        String $ecsOriginalFilePath = this.getEcsOriginalFilePath();
        result = result * 59 + ($ecsOriginalFilePath == null ? 43 : $ecsOriginalFilePath.hashCode());
        String $ecsReimbursementFilePath = this.getEcsReimbursementFilePath();
        result = result * 59 + ($ecsReimbursementFilePath == null ? 43 : $ecsReimbursementFilePath.hashCode());
        String $errorReport = this.getErrorReport();
        result = result * 59 + ($errorReport == null ? 43 : $errorReport.hashCode());
        String $errorReportTo = this.getErrorReportTo();
        result = result * 59 + ($errorReportTo == null ? 43 : $errorReportTo.hashCode());
        String $recordLog = this.getRecordLog();
        result = result * 59 + ($recordLog == null ? 43 : $recordLog.hashCode());
        String $multiTenancy = this.getMultiTenancy();
        result = result * 59 + ($multiTenancy == null ? 43 : $multiTenancy.hashCode());
        String $softVersion = this.getSoftVersion();
        result = result * 59 + ($softVersion == null ? 43 : $softVersion.hashCode());
        String $igexinEnabled = this.getIgexinEnabled();
        result = result * 59 + ($igexinEnabled == null ? 43 : $igexinEnabled.hashCode());
        String $igexinAppid = this.getIgexinAppid();
        result = result * 59 + ($igexinAppid == null ? 43 : $igexinAppid.hashCode());
        String $igexinAppkey = this.getIgexinAppkey();
        result = result * 59 + ($igexinAppkey == null ? 43 : $igexinAppkey.hashCode());
        String $igexinMastersecret = this.getIgexinMastersecret();
        result = result * 59 + ($igexinMastersecret == null ? 43 : $igexinMastersecret.hashCode());
        String $appUpdateContent = this.getAppUpdateContent();
        result = result * 59 + ($appUpdateContent == null ? 43 : $appUpdateContent.hashCode());
        String $appVersion = this.getAppVersion();
        result = result * 59 + ($appVersion == null ? 43 : $appVersion.hashCode());
        String $testVersion = this.getTestVersion();
        result = result * 59 + ($testVersion == null ? 43 : $testVersion.hashCode());
        return result;
    }

    public String toString() {
        return "ConfigValueUtil(path=" + this.getPath() + ", licenseFilePath=" + this.getLicenseFilePath() + ", dataBackupFilePath=" + this.getDataBackupFilePath() + ", temporaryFilePath=" + this.getTemporaryFilePath() + ", systemFilePath=" + this.getSystemFilePath() + ", templateFilePath=" + this.getTemplateFilePath() + ", templateCodePath=" + this.getTemplateCodePath() + ", emailFilePath=" + this.getEmailFilePath() + ", biVisualPath=" + this.getBiVisualPath() + ", documentFilePath=" + this.getDocumentFilePath() + ", documentZip=" + this.getDocumentZip() + ", documentPreviewPath=" + this.getDocumentPreviewPath() + ", userAvatarFilePath=" + this.getUserAvatarFilePath() + ", imContentFilePath=" + this.getImContentFilePath() + ", fileType=" + this.getFileType() + ", documentEcbp=" + this.getDocumentEcbp() + ", iotAnalysisPath=" + this.getIotAnalysisPath() + ", allowUploadFileType=" + this.getAllowUploadFileType() + ", allowUploadImageType=" + this.getAllowUploadImageType() + ", allowPreviewFileType=" + this.getAllowPreviewFileType() + ", previewType=" + this.getPreviewType() + ", kkFileUrl=" + this.getKkFileUrl() + ", serviceDirectoryPath=" + this.getServiceDirectoryPath() + ", codeAreasName=" + this.getCodeAreasName() + ", webAnnexFilePath=" + this.getWebAnnexFilePath() + ", ecsOriginalFilePath=" + this.getEcsOriginalFilePath() + ", ecsReimbursementFilePath=" + this.getEcsReimbursementFilePath() + ", enablePreAuth=" + this.getEnablePreAuth() + ", errorReport=" + this.getErrorReport() + ", errorReportTo=" + this.getErrorReportTo() + ", recordLog=" + this.getRecordLog() + ", multiTenancy=" + this.getMultiTenancy() + ", softVersion=" + this.getSoftVersion() + ", igexinEnabled=" + this.getIgexinEnabled() + ", igexinAppid=" + this.getIgexinAppid() + ", igexinAppkey=" + this.getIgexinAppkey() + ", igexinMastersecret=" + this.getIgexinMastersecret() + ", appUpdateContent=" + this.getAppUpdateContent() + ", appVersion=" + this.getAppVersion() + ", testVersion=" + this.getTestVersion() + ")";
    }
}

