package com.bringspring.common.database.model.dto;

import com.bringspring.common.database.source.DbBase;
import com.bringspring.common.database.model.DataSourceModel;
import lombok.Data;

import java.sql.Connection;

/**
 * 数据连接相关数据传输对象
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/10/12
 */
@Data
public class DbConnDTO {

    public DbConnDTO(DbBase dbBase, DataSourceModel dbSource, Connection conn){
        this.dbBase = dbBase;
        this.dbSource = dbSource;
        this.conn = conn;
    }

    /**
     * 数据库基类
     */
    private DbBase dbBase;

    /**
     * 数据源信息
     */
    private DataSourceModel dbSource;

    /**
     * 数据连接
     */
    private Connection conn;
}
