/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.database.enums.datatype.viewshow;

import com.bringspring.common.database.enums.datatype.DtDM;
import com.bringspring.common.database.enums.datatype.DtKingbaseES;
import com.bringspring.common.database.enums.datatype.DtMySQL;
import com.bringspring.common.database.enums.datatype.DtOracle;
import com.bringspring.common.database.enums.datatype.DtPostgreSQL;
import com.bringspring.common.database.enums.datatype.DtSQLServer;
import com.bringspring.common.database.enums.datatype.interfaces.DtInterface;
import com.bringspring.common.database.model.DataTypeModel;
import com.bringspring.common.database.source.DbBase;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.StringUtils;

public enum DataTypeEnum {
    VARCHAR("varchar", DtMySQL.VARCHAR, DtOracle.VARCHAR2, DtSQLServer.VARCHAR, DtDM.VARCHAR, DtKingbaseES.VARCHAR, DtPostgreSQL.VARCHAR),
    DATE_TIME("datetime", DtMySQL.DATA_TIME, DtOracle.DATA, DtSQLServer.DATA_TIME, DtDM.DATA_TIME, DtKingbaseES.TIME_STAMP, DtPostgreSQL.TIME_STAMP),
    DECIMAL("decimal", DtMySQL.DECIMAL, DtOracle.NUMBER_DECIMAL, DtSQLServer.DECIMAL, DtDM.DECIMAL, DtKingbaseES.NUMERIC, DtPostgreSQL.NUMERIC),
    TEXT("text", DtMySQL.TEXT, DtOracle.CLOB, DtSQLServer.TEXT, DtDM.TEXT, DtKingbaseES.TEXT, DtPostgreSQL.TEXT),
    INT("int", DtMySQL.INT, DtOracle.NUMBER_INT, DtSQLServer.INT, DtDM.INT, DtKingbaseES.INTEGER, DtPostgreSQL.INT4),
    BIGINT("bigint", DtMySQL.BIGINT, DtOracle.NUMBER_BIG, DtSQLServer.BIGINT, DtDM.BIGINT, DtKingbaseES.BIGINT, DtPostgreSQL.INT8),
    ORACLE_NUMBER("\u6570\u5b57\u7c7b\u578b", null, DtOracle.NUMBER_VIEW, null, null, null, null);

    private final String viewFieldType;
    private final DtMySQL dtMySQL;
    private final DtOracle dtOracle;
    private final DtSQLServer dtSQLServer;
    private final DtDM dtDM;
    private final DtKingbaseES dtKingbaseES;
    private final DtPostgreSQL dtPostgreSQL;

    private DataTypeEnum(String viewFieldType, DtMySQL dtMySQL, DtOracle dtOracle, DtSQLServer dtSQLServer, DtDM dtDM, DtKingbaseES dtKingbaseES, DtPostgreSQL dtPostgreSQL) {
        this.viewFieldType = viewFieldType;
        this.dtMySQL = dtMySQL;
        this.dtOracle = dtOracle;
        this.dtSQLServer = dtSQLServer;
        this.dtDM = dtDM;
        this.dtKingbaseES = dtKingbaseES;
        this.dtPostgreSQL = dtPostgreSQL;
    }

    public static DataTypeModel getDataTypeModel(String viewFieldType, DbBase db) throws DataException {
        if (StringUtils.isNotNull(viewFieldType)) {
            for (DataTypeEnum value : DataTypeEnum.values()) {
                if (!value.getViewFieldType().equalsIgnoreCase(viewFieldType)) continue;
                return db.getDataTypeModel(value);
            }
        }
        return null;
    }

    public String getViewFieldType() {
        return this.viewFieldType;
    }

    public DtInterface getDtDM() {
        return this.dtDM;
    }

    public DtInterface getDtMySQL() {
        return this.dtMySQL;
    }

    public DtInterface getDtOracle() {
        return this.dtOracle;
    }

    public DtInterface getDtKingbaseES() {
        return this.dtKingbaseES;
    }

    public DtInterface getDtSQLServer() {
        return this.dtSQLServer;
    }

    public DtInterface getDtPostgreSQL() {
        return this.dtPostgreSQL;
    }
}

