/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.util;

import com.bringspring.common.database.model.TenantLinkModel;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import java.util.List;

public class ParameterUtil {
    public static String parse(String openToken, String closeToken, String text, List<String> list) {
        if (text == null || text.isEmpty()) {
            return "";
        }
        int start = text.indexOf(openToken);
        if (start == -1) {
            return text;
        }
        char[] src = text.toCharArray();
        int offset = 0;
        StringBuilder builder = new StringBuilder();
        StringBuilder expression = null;
        while (start > -1) {
            if (start > 0 && src[start - 1] == '\\') {
                builder.append(src, offset, start - offset - 1).append(openToken);
                offset = start + openToken.length();
            } else {
                if (expression == null) {
                    expression = new StringBuilder();
                } else {
                    expression.setLength(0);
                }
                builder.append(src, offset, start - offset);
                offset = start + openToken.length();
                int end = text.indexOf(closeToken, offset);
                while (end > -1) {
                    if (end > offset && src[end - 1] == '\\') {
                        expression.append(src, offset, end - offset - 1).append(closeToken);
                        offset = end + closeToken.length();
                        end = text.indexOf(closeToken, offset);
                        continue;
                    }
                    expression.append(src, offset, end - offset);
                    break;
                }
                list.add(expression.toString());
                if (end == -1) {
                    builder.append(src, start, src.length - start);
                    offset = src.length;
                } else {
                    offset = end + closeToken.length();
                }
            }
            start = text.indexOf(openToken, offset);
        }
        if (offset < src.length) {
            builder.append(src, offset, src.length - offset);
        }
        return builder.toString();
    }

    public static String getUrl(TenantLinkModel model) {
        if (model != null) {
            if (StringUtils.isNotEmpty(model.getConnectionStr())) {
                return model.getConnectionStr();
            }
            String url = "";
            if ("mysql".equalsIgnoreCase(model.getDbType())) {
                url = "jdbc:mysql://{host}:{port}/{dbname}";
            } else if ("SQLServer".equalsIgnoreCase(model.getDbType())) {
                url = "jdbc:sqlserver://{host}:{port};databaseName={dbname}";
            } else if ("Oracle".equalsIgnoreCase(model.getDbType())) {
                url = "jdbc:oracle:thin:@//{host}:{port}/{schema}";
            } else if ("DM8".equalsIgnoreCase(model.getDbType())) {
                url = "jdbc:dm://{host}:{port}/{schema}";
            } else if ("KingbaseES".equalsIgnoreCase(model.getDbType())) {
                url = "jdbc:kingbase8://{host}:{port}/{dbname}?currentSchema={schema}";
            } else if ("PostgreSQL".equalsIgnoreCase(model.getDbType())) {
                url = "jdbc:postgresql://{host}:{port}/{dbname}";
            }
            url = url.replace("{host}", model.getHost());
            url = url.replace("{port}", model.getPort());
            url = url.replace("{dbname}", model.getServiceName());
            url = url.replace("{schema}", model.getDbSchema());
            return url;
        }
        return null;
    }

    public static String getDbType(String driverName) {
        if (StringUtils.isNotEmpty(driverName)) {
            String dbType = "";
            if (driverName.contains("mysql")) {
                dbType = "MySQL";
            } else if (driverName.contains("sqlserver")) {
                dbType = "SQLServer";
            } else if (driverName.contains("oracle")) {
                dbType = "Oracle";
            } else if (driverName.contains("dm")) {
                dbType = "DM8";
            } else if (driverName.contains("kingbase8")) {
                dbType = "KingbaseES";
            } else if (driverName.contains("postgresql")) {
                dbType = "PostgreSQL";
            }
            return dbType;
        }
        return null;
    }

    public static Integer getOriginType() {
        String clientType = ServletUtils.getRequest().getHeader("jsbos-origin");
        if (StringUtils.isNotEmpty(clientType) && clientType.toLowerCase().equals("pc")) {
            return 1;
        }
        return 2;
    }
}

