/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.util.context;

import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
@Lazy(value=false)
public class SpringContext
implements ApplicationContextAware {
    private static ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        SpringContext.applicationContext = applicationContext;
    }

    public static ApplicationContext getApplicationContext() {
        SpringContext.assertApplicationContext();
        return applicationContext;
    }

    public static <T> T getBean(String beanName) {
        SpringContext.assertApplicationContext();
        return (T)applicationContext.getBean(beanName);
    }

    public static <T> T getBean(Class<T> beanName) {
        SpringContext.assertApplicationContext();
        return (T)applicationContext.getBean(beanName);
    }

    private static void assertApplicationContext() {
        if (applicationContext == null) {
            throw new RuntimeException("applicaitonContext\u5c5e\u6027\u4e3anull,\u8bf7\u68c0\u67e5\u662f\u5426\u6ce8\u5165\u4e86SpringContextHolder!");
        }
    }
}

