package com.bringspring.common.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 接口传输加密
 * 加密请求和返回结果: @EncryptApi
 * 只加密请求: @EncryptApi(encryptRequest = false)
 * 只加密返回结果: @EncryptApi(encryptResponse = false)
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD,ElementType.PARAMETER})
public @interface EncryptApi {

    /**
     * 加密请求内容
     */
    boolean encryptRequest() default true;

    /**
     * 加密返回结果
     */
    boolean encryptResponse() default true;
}
