package com.bringspring.common.auth.service;

/**
 * 第三方认证服务接口
 */
public interface ThirdPartyAuthService {

    /**
     * 第三方认证调用统一入口，传入第三方类型、产品ID和验证码
     *
     * @param thirdType
     * @param productId
     * @param code
     * @return
     */
    boolean thirdPartyVerify(String thirdType, String productId, String code);

    /**
     * 智行企业微信验证码核销接口，传入产品ID和验证码
     *
     * @param productId 演示产品唯一标识
     * @param code      验证码
     * @return
     */
    boolean rkkjWxworkVerifyCode(String productId, String code);
}
