package com.bringspring.common.database.plugins;

import com.bringspring.common.constant.TableFieldsNameConst;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.schema.Column;

import java.util.List;

/**
 * @author RKKJ开发平台组
 * @user N
 * @copyright 荣科科技股份有限公司
 * @date 2023/1/3 15:07
 */
public interface LogicDeleteHandler {

    String DELETE_FIELD = TableFieldsNameConst.DELETE_MARK;
    String DELETESQL = "UPDATE a SET " + DELETE_FIELD + " = 1";


    /**
     * 获取租户 ID 值表达式，只支持单个 ID 值
     * <p>
     *
     * @return 租户 ID 值表达式
     */
    Expression getNotDeletedValue();

    /**
     * 获取租户字段名
     * <p>
     * 默认字段名叫: tenant_id
     *
     * @return 租户字段名
     */
    default String getLogicDeleteColumn() {
        return DELETE_FIELD;
    }

    /**
     * 获取租户字段名
     * <p>
     * 默认字段名叫: tenant_id
     *
     * @return 租户字段名
     */
    default String getDeleteSql() {
        return DELETESQL;
    }

    /**
     * 根据表名判断是否忽略拼接多租户条件
     * <p>
     * 默认都要进行解析并拼接多租户条件
     *
     * @param tableName 表名
     * @return 是否忽略, true:表示忽略，false:需要解析并拼接多租户条件
     */
    default boolean ignoreTable(String tableName) {
        return false;
    }

    /**
     * 忽略插入租户字段逻辑
     *
     * @param columns        插入字段
     * @param tenantIdColumn 租户 ID 字段
     * @return
     */
    default boolean ignoreInsert(List<Column> columns, String tenantIdColumn) {
        return columns.stream().map(Column::getColumnName).anyMatch(i -> i.equalsIgnoreCase(tenantIdColumn));
    }


}
