package com.bringspring.common.database.plugins;

import com.bringspring.common.database.util.ResetSetHolder;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

/**
 * Mybatis ResultSet拦截器
 * @see ResetSetHolder
 * @author RKKJ开发平台组
 * @user N
 * @copyright 荣科科技股份有限公司
 * @date 2022/10/14 16:29
 */
@Intercepts({@Signature(type = ResultSetHandler.class, method = "handleResultSets", args = {Statement.class})})
public class ResultSetInterceptor implements Interceptor {


    @Override
    public Object intercept(Invocation invocation) throws Throwable {
        Object[] args = invocation.getArgs();
        Statement statement = (Statement) args[0];
        ResultSet rs = getFirstResultSet(statement);
        if (rs != null) {
            ResetSetHolder.setResultSet(rs);
        }
        Object result;
        try{
            result = invocation.proceed();
        }finally{
            ResetSetHolder.clear();
        }
        return result;
    }


    private ResultSet getFirstResultSet(Statement stmt) throws SQLException {
        ResultSet rs = stmt.getResultSet();
        while (rs == null) {
            if (stmt.getMoreResults()) {
                rs = stmt.getResultSet();
            } else if (stmt.getUpdateCount() == -1) {
                break;
            }
        }
        return rs;
    }
}
