package com.bringspring.common.database.sql.param;

import com.bringspring.common.database.model.dbfield.DbFieldModel;
import com.bringspring.common.database.model.dbtable.DbTableFieldModel;
import com.bringspring.common.database.source.DbBase;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.util.List;

/**
 * 类功能
 *
 * @author RKKJ开发平台组
 * @version v3.4.5
 * @copyrignt 荣科科技股份有限公司
 * @date 2022-12-23
 */
@Data
public class FormatSqlDoris {

    private String primaryField;

    /**
     * 添加主键相关内容
     * @param sql 建表SQL
     * @param dbTableFieldModel 表字段对象
     * @param dbType 数据类型
     * @return sql语句
     */
    public static String getPrimaryFieldSql(String sql, DbTableFieldModel dbTableFieldModel, String dbType){
        if(dbType.equals(DbBase.DORIS)) {
            List<DbFieldModel> dbFieldModelList = dbTableFieldModel.getDbFieldModelList();
            for (DbFieldModel dbFieldModel : dbFieldModelList) {
                if (dbFieldModel.getIsPrimaryKey()) {
                    sql = sql.replace("{primary_column}", dbFieldModel.getField());
                }
            }
            sql = sql.replace("{tableComment}", dbTableFieldModel.getComment());
        }
        return sql;
    }


    public static void orderUniqueColumn(String dbType, List<String> columnSqlList, DbTableFieldModel dbTableFieldModel){
        if(dbType.equals(DbBase.DORIS)) {
            for (DbFieldModel dbFieldModel : dbTableFieldModel.getDbFieldModelList()) {
                if (dbFieldModel.getIsPrimaryKey()) {
                    for (int i = 0; i < columnSqlList.size(); i++) {
                        if(columnSqlList.get(i).contains("\t" + dbFieldModel.getField())){
                            columnSqlList.add(0, columnSqlList.remove(i));
                        }
                    }
                }
            }

        }

    }


}
