package com.bringspring.common.properties;


import java.util.ArrayList;
import java.util.List;

/**
 * 放行的url
 * 由下方的URL列表加上配置里的URL组合
 *
 * @author RKKJ开发平台组
 * @version V3.1.0
 * @copyright 荣科科技股份有限公司（https://jsbos.bringspring.com）
 * @date 2021-03-24
 */
public class GatewayWhite {

    public static final String PREFIX = "gateway";


    /**
     * 放行不记录
     */
    public List<String> excludeUrl = new ArrayList<>();

    /**
     * 不验证Token, 记录访问
     */
    public List<String> whiteUrl = new ArrayList<>();

    /**
     * 禁止访问
     */
    public List<String> blockUrl = new ArrayList<>();

    /**
     * 禁止访问地址的白名单IP
     * startsWith匹配, 访问IP.startsWith(whiteIP)
     */
    public List<String> whiteIp = new ArrayList<>();

    public GatewayWhite() {
        interceptPath();
        whitePath();
        excludePath();
        whiteIp();
    }


    public List<String> getWhiteUrl() {
        return new ArrayList<>(whiteUrl);
    }

    public List<String> getBlockUrl() {
        return new ArrayList<>(blockUrl);
    }

    public List<String> getExcludeUrl() {
        return new ArrayList<>(excludeUrl);
    }

    public List<String> getWhiteIp() {
        return new ArrayList<>(whiteIp);
    }

    public void setWhiteUrl(List<String> whiteUrl) {
        whitePath();
        this.whiteUrl.addAll(whiteUrl);
    }

    public void setBlockUrl(List<String> blockUrl) {
        interceptPath();
        this.blockUrl.addAll(blockUrl);
    }

    public void setExcludeUrl(List<String> excludeUrl) {
        excludePath();
        this.excludeUrl.addAll(excludeUrl);
    }

    public void setWhiteIp(List<String> whiteIp) {
        whiteIp();
        this.whiteIp.addAll(whiteIp);
    }

    protected void interceptPath() {
        blockUrl.clear();
        blockUrl.add("/actuator/**");
        blockUrl.add("/api/*/actuator/**");
        blockUrl.add("/doc.html");
        blockUrl.add("/swagger-resources/**");
        blockUrl.add("/swagger-ui/**");
        blockUrl.add("/api/*/v?/api-docs/**");
        blockUrl.add("/v?/api-docs/**");
    }

    protected void whitePath() {
        whiteUrl.clear();
        //oauth
        whiteUrl.add("/api/oauth/Login/**");
        whiteUrl.add("/api/oauth/Logout/**");
        whiteUrl.add("/api/oauth/resetOfficialPassword/**");
        whiteUrl.add("/api/oauth/codeCertificate");
        whiteUrl.add("/api/oauth/codeCertificateStatus/*");

        // 新增：WebFilterConfig中的特有路径
        whiteUrl.add("/api/oauth/LogingByQy");
        whiteUrl.add("/api/oauth/getUserIdByCode");
        whiteUrl.add("/api/oauth/getFile");
        whiteUrl.add("/api/oauth/register");
        whiteUrl.add("/api/oauth/SmsCode/**");
        whiteUrl.add("/api/oauth/getQyhConfig");
        whiteUrl.add("/api/oauth/getSystemAddress/{terminal}");

        // APP
        whiteUrl.add("/api/app/Version");

        //websocket
        whiteUrl.add("/api/message/websocket/*");
        whiteUrl.add("/message/websocket"); // 新增：WebFilterConfig中的路径

        //大屏图片
        whiteUrl.add("/api/file/VisusalImg/**");
        whiteUrl.add("/api/blade-visual/map/data");
        whiteUrl.add("/api/blade-visual/category/list");
        whiteUrl.add("/api/blade-visual/visual/put-file/**");

        // 新增：WebFilterConfig中的特有路径
        whiteUrl.add("/api/visualdev/DataScreen/Images/**");

        //数据地图
        whiteUrl.add("/api/system/DataMap/**");

        // 新增：WebFilterConfig中的特有路径（更具体的路径，已由通配符覆盖但保留明确声明）
        whiteUrl.add("/api/system/DataMap/{id}/Data");

        //代码下载接口
        whiteUrl.add("/api/visualdev/Generater/DownloadVisCode");
        whiteUrl.add("/api/visualdev/Generater/DownloadVisCode/**"); // 新增：WebFilterConfig中的路径

        //多租户
        whiteUrl.add("/api/tenant/DbName/**");
        whiteUrl.add("/api/tenant/login");
        whiteUrl.add("/api/tenant/logout");

        //报表导出
        whiteUrl.add("/api/Report/data/Download");

        //extend
        whiteUrl.add("/api/extend/DocumentPreview/**");

        // 新增：WebFilterConfig中的特有路径
        whiteUrl.add("/api/extend/Document/getShareEntityById/{id}");
        whiteUrl.add("/api/extend/DocumentPreview/down/{fileName}");

        //file模块不拦截
        //文件下载接口
        whiteUrl.add("/api/file/VisusalImg/**");
        whiteUrl.add("/api/file/AppStartInfo/*");
        whiteUrl.add("/api/file/Image/**");
        whiteUrl.add("/api/file/Download");
        whiteUrl.add("/api/file/ImageCode/**");

        // 新增：WebFilterConfig中的特有路径
        whiteUrl.add("/api/file/Uploader/**");
        whiteUrl.add("/api/file/DownloadModel/**");

        whiteUrl.add("/api/system/DictionaryData/*/Data/Selector");

        // 新增：WebFilterConfig中的特有路径（更具体的路径，已由通配符覆盖但保留明确声明）
        whiteUrl.add("/api/system/DictionaryData/{dictionaryTypeId}/Data/Selector");

        whiteUrl.add("/api/datareport/pdf/show");
        whiteUrl.add("/api/datareport/preview/loadPagePaper");
        whiteUrl.add("/api/datareport/pdf");
        whiteUrl.add("/api/datareport/word");
        whiteUrl.add("/api/datareport/excel/**");
        whiteUrl.add("/api/datareport/Data/*/Actions/Export");

        //报表模板导入
        whiteUrl.add("/api/datareport/import");
        whiteUrl.add("/api/system/DataInterface/*/Actions/Response");

        // 新增：WebFilterConfig中的特有路径（更具体的路径，已由通配符覆盖但保留明确声明）
        whiteUrl.add("/api/system/DataInterface/{id}/Actions/Response");

        whiteUrl.add("/api/system/DataInterface/Actions/GetAuth");

        //swagger3
        whiteUrl.add("/doc.html");
        whiteUrl.add("/webjars/**");
        whiteUrl.add("/api/*/v?/api-docs/**");
        whiteUrl.add("/v?/api-docs/**");
        whiteUrl.add("/swagger-ui/**");
        whiteUrl.add("/swagger-resources/**");

        // 新增：WebFilterConfig中的特有路径
        whiteUrl.add("/v3/**");

        whiteUrl.add("/csrf");
        whiteUrl.add("/api/oauth/ImageCode/**");

        // 新增：WebFilterConfig中的特有路径（更具体的路径，已由通配符覆盖但保留明确声明）
        whiteUrl.add("/api/oauth/ImageCode/{codeLength}/{timestamp}");

        whiteUrl.add("/api/oauth/getConfig/*");
        whiteUrl.add("/api/oauth/getConfig/{account}");
        whiteUrl.add("/api/oauth/getLoginConfig");
        whiteUrl.add("/api/oauth/getTicketStatus/*");
        whiteUrl.add("/api/oauth/getTicket");

        //扫描登录放行调用接口
        whiteUrl.add("/api/oauth/setCodeCertificateStatus/{ticket}/{status}");

        whiteUrl.add("/api/message/ShortLink/**");
        whiteUrl.add("/api/message/WechatOpen/token/**");

        //在线表单外链触发接口
        whiteUrl.add("/api/visualdev/ShortLink/**");

        //webhook两个接口
        whiteUrl.add("/api/visualdev/Hooks/*");
        whiteUrl.add("/api/visualdev/Hooks/*/params/*");
        whiteUrl.add("/api/workflow/Hooks/*");
        whiteUrl.add("/api/workflow/task/Hooks");
        whiteUrl.add("/api/workflow/Hooks/*/params/*");

        whiteUrl.add("/api/system/Location/*");
        whiteUrl.add("/api/*/white/**");
        whiteUrl.add("/api/*/*/white/**");

        // 新增：WebFilterConfig中的特有路径
        whiteUrl.add("/api/service/**");
        whiteUrl.add("/api/white/**");
        whiteUrl.add("/api/system/Menu/systemList");

        // 新增：WebFilterConfig中的前端路径
        whiteUrl.add("/web/**");
        whiteUrl.add("/mobile/**");
        whiteUrl.add("/static/**");
        whiteUrl.add("/cdn/**");
        whiteUrl.add("/*.icon");
        whiteUrl.add("/*.js");
        whiteUrl.add("/index.html");
        whiteUrl.add("/");
    }

    protected void excludePath() {
        excludeUrl.clear();
        excludeUrl.add("/favicon.ico");
        excludeUrl.add("/api/message/websocket/*");
        excludeUrl.add("/message/websocket"); // 新增：WebFilterConfig中的路径
    }

    protected void whiteIp() {
        whiteIp.clear();
        whiteIp.add("127.0.0.1");
    }

}
