package com.bringspring.common.security.filter;

import com.baomidou.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import com.bringspring.common.auth.util.TenantProvider;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.database.util.LogicDeleteHelper;
import com.bringspring.common.database.util.NotTenantPluginHolder;
import com.bringspring.common.database.util.TenantDataSourceUtil;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.core.annotation.Order;
import org.springframework.web.filter.OncePerRequestFilter;

import java.io.IOException;


/**
 * 线程缓存清理
 */
@Slf4j
@Order(-99)
public class ClearThreadContextFilter extends OncePerRequestFilter {


    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        try {
            filterChain.doFilter(request, response);
        } finally {
            //清除线程缓存
            UserProvider.clearLocalUser();
            TenantProvider.clearBaseSystemIfo();
            TenantDataSourceUtil.clearLocalTenantInfo();
            DynamicDataSourceContextHolder.clear();
            NotTenantPluginHolder.clearNotSwitchFlag();
            LogicDeleteHelper.clearIgnoreLogicDelete();
            LogicDeleteHelper.clearDeleteAction();
        }
    }

}
