package com.bringspring.common.sms.util.third;

import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.util.wxutil.HttpUtil;

/**
 * 企业微信的接口类
 *
 * @版本： V1.0.0
 * @版权： 荣科科技股份有限公司
 * @作者： RKKJ开发平台组
 * @日期： 2021/4/21 8:20
 */
public class QyWebChatUtil {

    /**
     * 获取企业微信TOKEN的接口路径
     */
    public static final String TOKEN = "https://qyapi.weixin.qq.com/cgi-bin/gettoken?corpid=%s&corpsecret=%s";

    /**
     * 往企业微信发送消息的接口路径
     */
    public static final String SEND_MESSAGE = "https://qyapi.weixin.qq.com/cgi-bin/message/send?access_token=%s";
    public static final String SEND_MESSAGE_LINKEDCORP = "https://qyapi.weixin.qq.com/cgi-bin/linkedcorp/message/send" +
            "?access_token=%s";

    /**
     * 获取接口访问凭证
     */
    public static JSONObject getAccessToken(String corpId, String corpSecret)  {
        JSONObject retMsg = new JSONObject();
        JSONObject rstObj = HttpUtil.httpRequest(String.format(TOKEN,corpId, corpSecret), "GET", null);
//        JSONObject rstObj = HttpUtil.httpRequest(QyApi.getTokenUrl(corpId, corpSecret), "GET", null);
        return rstObj;
    }


    /**
     * 发送消息 20210416 Add By GongXishan
     * 不抛出异常，返回Json
     */
    public static JSONObject sendMessage(String message, String accessToken){
        JSONObject retMsg = new JSONObject();
        boolean codeFlag = true;
        String errorMsg = "";
        JSONObject rstObj = HttpUtil.httpRequest(String.format(SEND_MESSAGE, accessToken), "POST", message);
//        JSONObject rstObj = HttpUtil.httpRequest(QyApi.sendMessage(accessToken), "POST", message);
        if (HttpUtil.isWxError(rstObj)) {
            codeFlag = false;
            errorMsg = rstObj.toString();
        }
        retMsg.put("code",codeFlag);
        retMsg.put("error",errorMsg);
        return retMsg;
    }

    /**
     * 发送消息 20210416 Add By GongXishan
     * 不抛出异常，返回Json
     */
    public static JSONObject sendMessageLink(String message, String accessToken){
        JSONObject retMsg = new JSONObject();
        boolean codeFlag = true;
        String errorMsg = "";
        JSONObject rstObj = HttpUtil.httpRequest(String.format(SEND_MESSAGE_LINKEDCORP, accessToken), "POST", message);
//        JSONObject rstObj = HttpUtil.httpRequest(QyApi.sendMessage(accessToken), "POST", message);
        if (HttpUtil.isWxError(rstObj)) {
            codeFlag = false;
            errorMsg = rstObj.toString();
        }
        retMsg.put("code",codeFlag);
        retMsg.put("error",errorMsg);
        return retMsg;
    }


    /**
     * 向企业微信发送文本卡片消息
     * @param corpId
     * @param corpSecret
     * @param agentId
     * @param toUserId
     * @param title
     * @param contents
     * @param url 跳转链接地址
     * @return
     */
    public static JSONObject sendWxMessage(String corpId, String corpSecret, String agentId, String toUserId,String title, String contents,String url)  {
        JSONObject retMsg = null;
        JSONObject message = null;
        JSONObject tokenObject = null;
        JSONObject content = null;

        message = new JSONObject();
        message.put("touser", toUserId);
        message.put("agentid", agentId);
        content = new JSONObject();
        content.put("title", title);
        content.put("description", contents);
        content.put("url", url);
        message.put("textcard", content);
        message.put("msgtype", "textcard");
        tokenObject = getAccessToken(corpId, corpSecret);
        if(tokenObject.getString("access_token")!=null && !"".equals(tokenObject.getString("access_token"))){
            retMsg = sendMessage(message.toJSONString(), tokenObject.getString("access_token"));
        }else
        {
            retMsg.put("code",false);
            retMsg.put("error","access_token值为空,不能发送信息！");
        }
        return retMsg;
    }
    /**
     * 向互联企业微信发送文本卡片消息
     * @param corpId
     * @param corpSecret
     * @param agentId
     * @param toUserId
     * @param title
     * @param contents
     * @param url 跳转链接地址
     * @return
     */
    public static JSONObject sendLinkWxMessage(String corpId, String corpSecret, String agentId, String[] toUserId, String title, String contents, String url)  {
        JSONObject retMsg = null;
        JSONObject message = null;
        JSONObject tokenObject = null;
        JSONObject content = null;

        message = new JSONObject();
        message.put("touser", toUserId);
        message.put("agentid", agentId);
        content = new JSONObject();
        content.put("title", title);
        content.put("description", contents);
        content.put("url", url);
        message.put("textcard", content);
        message.put("msgtype", "textcard");
        tokenObject = getAccessToken(corpId, corpSecret);
        if(tokenObject.getString("access_token")!=null && !"".equals(tokenObject.getString("access_token"))){
            retMsg = sendMessageLink(message.toJSONString(), tokenObject.getString("access_token"));
        }else
        {
            retMsg.put("code",false);
            retMsg.put("error","access_token值为空,不能发送信息！");
        }
        return retMsg;
    }

}
