package com.bringspring.common.util.jscript;

import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import org.springframework.util.ReflectionUtils;

import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;

/**
 * Java执行js代码工具类
 *
 * @author ：RKKJ开发平台组
 * @version: V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date ：2022/5/28 9:44
 */
public class JScriptUtil {

    private static ScriptEngineFactory scriptEngineFactory;
    private static Method createMathod;


    static {
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        if(!scriptEngineManager.getEngineFactories().isEmpty()) {
            scriptEngineFactory = scriptEngineManager.getEngineFactories().get(0);
            createMathod = ReflectionUtils.findMethod(scriptEngineFactory.getClass(), "getScriptEngine", String[].class);
        }else{
            throw new RuntimeException("JS引擎为空");
        }
    }
    /**
     * 数据接口通用定义函数
     */
    public static final String JSCONTENT = "var method = function(data) {" +
            "${jsContent}" +
            "};" +
            "var result = method(JSON.parse('${data}'));" +
            "JSON.stringify(result);";

    /**
     * 调用js代码
     * @param script 脚本内容
     * @return 如果JS内返回的是对象 返回内容为ScriptObjectMirror
     * @throws ScriptException
     */
    public static Object callJs(String script) throws ScriptException {
        ScriptEngine scriptEngine = null;
        try {
            scriptEngine = (ScriptEngine) createMathod.invoke(scriptEngineFactory, new Object[]{new String[]{"--no-java"}});
        } catch (Exception e) {
            throw new RuntimeException("创建JS引擎失败", e);
        }
        return scriptEngine.eval(script);
    }


    /**
     * 调用js代码, 处理JSON数据 返回JSON数据
     *
     * @param dataProcessing 数据处理函数
     * @param data JSON对象/数组
     * @return JSON对象/数组
     */
    public static Object callJs(String dataProcessing, Object data) throws ScriptException {
        String jsContent = getJsContent(dataProcessing);
        if (StringUtils.isEmpty(dataProcessing)) {
            return data;
        }
        String replace = JSCONTENT.replace("${jsContent}", jsContent);
        replace = replace.replace("${data}", JsonUtil.getObjectToString(data));
        Object result = null;
        try {
            result = callJs(replace);
        } catch (Exception e) {
            throw e;
        }
        try {
            List<Map<String, Object>> jsonToListMap = JsonUtil.getJsonToListMap(result.toString());
            return jsonToListMap;
        } catch (Exception e) {
            try{
                Map<String, Object> map = JsonUtil.stringToMap(result.toString());
                return map;
            }catch (Exception json) {
                return result.toString().replace("\"","");
            }
        }
    }

    /**
     * 返回js内容
     *
     * @param dataProcessing
     * @return
     */
    public static String getJsContent(String dataProcessing) {
        if (StringUtils.isNotEmpty(dataProcessing) && dataProcessing.length() > 0) {
            // 获取位置
            int indexOf = dataProcessing.indexOf("{");
            if (indexOf > -1) {
                dataProcessing = dataProcessing.substring(indexOf + 1);
            }
            int lastIndexOf = dataProcessing.lastIndexOf("}");
            if (lastIndexOf > -1) {
                dataProcessing = dataProcessing.substring(0, lastIndexOf);
            }
            return dataProcessing;
        }
        return "";
    }

}
