/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.config.minio;

import com.bringspring.common.config.minio.MinioConfigurationProperties;
import com.bringspring.common.util.StringUtils;
import io.minio.MinioClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@EnableConfigurationProperties(value={MinioConfigurationProperties.class})
@Component
public class MyMinioClient {
    @Autowired
    private MinioConfigurationProperties minioConfigurationProperties;
    @Autowired
    private DefaultListableBeanFactory defaultListableBeanFactory;

    @Bean
    public MinioClient minioClient() {
        MinioClient minioClient = null;
        if (StringUtils.isNotEmpty(this.minioConfigurationProperties.getAccessKey())) {
            minioClient = MinioClient.builder().endpoint(this.minioConfigurationProperties.getEndpoint()).credentials(this.minioConfigurationProperties.getAccessKey(), this.minioConfigurationProperties.getSecretKey()).build();
            this.defaultListableBeanFactory.registerSingleton("minioClient", (Object)minioClient);
        } else {
            minioClient = MinioClient.builder().endpoint("yourEndpoint").credentials("yourAccessKey", "yourSecretKey").build();
            this.defaultListableBeanFactory.registerSingleton("minioClient", (Object)minioClient);
        }
        return minioClient;
    }
}

