/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.database.config;

import com.baomidou.dynamic.datasource.DynamicRoutingDataSource;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.dynamic.datasource.aop.DynamicDataSourceAnnotationAdvisor;
import com.baomidou.dynamic.datasource.creator.DataSourceProperty;
import com.baomidou.dynamic.datasource.processor.DsProcessor;
import com.baomidou.dynamic.datasource.provider.DynamicDataSourceProvider;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DynamicDataSourceProperties;
import com.baomidou.mybatisplus.autoconfigure.SpringBootVFS;
import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.baomidou.mybatisplus.core.incrementer.IKeyGenerator;
import com.baomidou.mybatisplus.core.injector.ISqlInjector;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.extension.incrementer.H2KeyGenerator;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.handler.TenantLineHandler;
import com.baomidou.mybatisplus.extension.plugins.inner.DynamicTableNameInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.OptimisticLockerInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.TenantLineInnerInterceptor;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import com.bringspring.common.base.entity.SuperBaseEntity;
import com.bringspring.common.config.ApplicationStartErrorCheck;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.constant.GlobalConst;
import com.bringspring.common.database.config.MybatisPlusMetaObjectHandler;
import com.bringspring.common.database.model.entity.DbLinkEntity;
import com.bringspring.common.database.plugins.DynamicGeneratorInterceptor;
import com.bringspring.common.database.plugins.LogicDeleteHandler;
import com.bringspring.common.database.plugins.MyDefaultMasterSlaveAutoRoutingPlugin;
import com.bringspring.common.database.plugins.MyDefaultSqlInjector;
import com.bringspring.common.database.plugins.MyDynamicDataSourceAutoRollbackInterceptor;
import com.bringspring.common.database.plugins.MyDynamicRoutingDataSource;
import com.bringspring.common.database.plugins.MyLogicDeleteInnerInterceptor;
import com.bringspring.common.database.plugins.MySchemaInnerInterceptor;
import com.bringspring.common.database.plugins.MyTenantLineInnerInterceptor;
import com.bringspring.common.database.plugins.MyTenantMasterSlaveAutoRoutingPlugin;
import com.bringspring.common.database.plugins.ResultSetInterceptor;
import com.bringspring.common.database.source.DbBase;
import com.bringspring.common.database.util.ConnUtil;
import com.bringspring.common.database.util.DataSourceUtil;
import com.bringspring.common.database.util.DbTypeUtil;
import com.bringspring.common.database.util.DynamicDataSourceUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.ClassUtil;
import com.bringspring.common.util.TenantHolder;
import com.github.pagehelper.PageInterceptor;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.sql.DataSource;
import lombok.Generated;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.NullValue;
import net.sf.jsqlparser.expression.StringValue;
import org.aopalliance.intercept.MethodInterceptor;
import org.apache.ibatis.builder.MapperBuilderAssistant;
import org.apache.ibatis.logging.slf4j.Slf4jImpl;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.type.JdbcType;
import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.Advisor;
import org.springframework.aop.Pointcut;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

@Configuration
@ComponentScan(value={"com.bringspring"})
@DependsOn(value={"tenantDataSourceUtil", "threadPoolExecutorUtil"})
@MapperScan(basePackages={"com.bringspring.**.mapper"})
public class MybatisPlusConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MybatisPlusConfig.class);
    static final String ALIASES_PACKAGE = "com.bringspring.**.entity";
    @Autowired
    private DataSourceUtil dataSourceUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;

    @Primary
    @Bean(name={"dataSourceSystem"})
    public DataSource dataSourceOne(DynamicDataSourceProperties properties, List<DynamicDataSourceProvider> providers) throws SQLException, IOException, URISyntaxException {
        DataSource dataSource = this.dynamicDataSource(properties, providers);
        this.initDynamicDataSource(dataSource, properties);
        return dataSource;
    }

    @Bean(name={"sqlSessionFactorySystem"})
    public SqlSessionFactory sqlSessionFactoryOne(@Qualifier(value="dataSourceSystem") DataSource dataSource, @Autowired(required=false) ISqlInjector sqlInjector) throws Exception {
        return this.createSqlSessionFactory(dataSource, sqlInjector);
    }

    @Bean
    @ConditionalOnClass(name={"org.springframework.cloud.loadbalancer.annotation.LoadBalancerClient"})
    public Object scanAllEntity(SqlSessionFactory sqlSessionFactory) {
        ApplicationStartErrorCheck.getApplicationInitThreadPool().execute(() -> {
            Set<Class<?>> classes = ClassUtil.scanCandidateComponents("com.bringspring", c -> !Modifier.isAbstract(c.getModifiers()) && SuperBaseEntity.SuperTBaseEntity.class.isAssignableFrom((Class<?>)c));
            for (Class<?> aClass : classes) {
                MapperBuilderAssistant builderAssistant = new MapperBuilderAssistant(sqlSessionFactory.getConfiguration(), "resource");
                builderAssistant.setCurrentNamespace(aClass.getName());
                TableInfoHelper.initTableInfo((MapperBuilderAssistant)builderAssistant, aClass);
            }
        });
        return null;
    }

    public MybatisPlusInterceptor mybatisPlusInterceptor() {
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        try {
            if (this.configValueUtil.isMultiTenancy()) {
                interceptor.addInnerInterceptor((InnerInterceptor)this.myTenantLineInnerInterceptor());
                interceptor.addInnerInterceptor((InnerInterceptor)this.mySchemaInnerInterceptor());
            }
            if (this.configValueUtil.isEnableLogicDelete()) {
                interceptor.addInnerInterceptor((InnerInterceptor)this.myLogicDeleteInnerInterceptor());
            }
            interceptor.addInnerInterceptor((InnerInterceptor)new PaginationInnerInterceptor());
            interceptor.addInnerInterceptor((InnerInterceptor)new OptimisticLockerInnerInterceptor());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return interceptor;
    }

    @Bean(value={"myLogicDeleteInnerInterceptor"})
    @ConditionalOnProperty(prefix="config", name={"EnableLogicDelete"}, havingValue="true")
    public MyLogicDeleteInnerInterceptor myLogicDeleteInnerInterceptor() {
        MyLogicDeleteInnerInterceptor myLogicDeleteInnerInterceptor = new MyLogicDeleteInnerInterceptor();
        myLogicDeleteInnerInterceptor.setLogicDeleteHandler(new LogicDeleteHandler(){

            @Override
            public Expression getNotDeletedValue() {
                Integer defValue = GlobalConst.LOGIC_NO_DELETE_VALUE;
                if (defValue == null) {
                    return new NullValue();
                }
                return new LongValue(((Object)defValue).toString());
            }

            @Override
            public String getLogicDeleteColumn() {
                return MybatisPlusConfig.this.configValueUtil.getLogicDeleteColumn();
            }
        });
        return myLogicDeleteInnerInterceptor;
    }

    @Bean(value={"myTenantLineInnerInterceptor"})
    @ConditionalOnProperty(prefix="config", name={"MultiTenancy"}, havingValue="true")
    public TenantLineInnerInterceptor myTenantLineInnerInterceptor() {
        MyTenantLineInnerInterceptor tenantLineInnerInterceptor = new MyTenantLineInnerInterceptor();
        tenantLineInnerInterceptor.setTenantLineHandler(new TenantLineHandler(){

            public Expression getTenantId() {
                return new StringValue(TenantHolder.getDatasourceName());
            }

            public String getTenantIdColumn() {
                return MybatisPlusConfig.this.configValueUtil.getMultiTenantColumn();
            }

            public boolean ignoreTable(String tableName) {
                return MybatisPlusConfig.this.configValueUtil.getMultiTenantIgnoreTable().contains(tableName.toLowerCase());
            }
        });
        return tenantLineInnerInterceptor;
    }

    @Bean(value={"mySchemaInnerInterceptor"})
    @ConditionalOnProperty(prefix="config", name={"MultiTenancy"}, havingValue="true")
    public DynamicTableNameInnerInterceptor mySchemaInnerInterceptor() throws Exception {
        DbLinkEntity dbLinkEntity = this.dataSourceUtil.init();
        DbBase dbBase = DbTypeUtil.getDb(dbLinkEntity);
        MySchemaInnerInterceptor dynamicTableNameInnerInterceptor = new MySchemaInnerInterceptor();
        HashMap map = new HashMap(150);
        ArrayList<String> tableNames = new ArrayList<String>();
        DbBase.dynamicAllTableName = tableNames;
        dynamicTableNameInnerInterceptor.setTableNameHandler(dbBase.getDynamicTableNameHandler());
        return dynamicTableNameInnerInterceptor;
    }

    @Bean(value={"myTenantMasterSlaveInterceptor"})
    @ConditionalOnProperty(prefix="config", name={"MultiTenancy"}, havingValue="true")
    public MyTenantMasterSlaveAutoRoutingPlugin myTenantMasterSlaveAutoRoutingPlugin(DataSource dataSource) {
        return new MyTenantMasterSlaveAutoRoutingPlugin(dataSource);
    }

    public MyDefaultMasterSlaveAutoRoutingPlugin myDefaultMasterSlaveAutoRoutingPlugin(DataSource dataSource) {
        return new MyDefaultMasterSlaveAutoRoutingPlugin(dataSource);
    }

    protected DataSource dynamicDataSource(DynamicDataSourceProperties properties, List<DynamicDataSourceProvider> providers) {
        MyDynamicRoutingDataSource dataSource = new MyDynamicRoutingDataSource(providers);
        dataSource.setPrimary(properties.getPrimary());
        dataSource.setStrict(properties.getStrict());
        dataSource.setStrategy(properties.getStrategy());
        dataSource.setP6spy(properties.getP6spy());
        dataSource.setSeata(properties.getSeata());
        return dataSource;
    }

    private void initDynamicDataSource(@Qualifier(value="dataSourceSystem") DataSource dataSource1, DynamicDataSourceProperties properties) throws DataException, SQLException, IOException, URISyntaxException {
        DynamicRoutingDataSource dataSource = (DynamicRoutingDataSource)dataSource1;
        boolean isPresentPrimary = properties.getDatasource().entrySet().stream().anyMatch(ds -> ((String)ds.getKey()).equals(properties.getPrimary()) || ((String)ds.getKey()).startsWith(properties.getPrimary() + "_") || properties.getPrimary().equals(((DataSourceProperty)ds.getValue()).getPoolName()));
        DynamicDataSourceUtil.dynamicDataSourceProperties = properties;
        if (!isPresentPrimary) {
            String url = ConnUtil.getUrl(this.dataSourceUtil, this.configValueUtil.isMultiTenancy() ? null : this.dataSourceUtil.getDbName());
            DataSourceProperty dataSourceProperty = DynamicDataSourceUtil.createDataSourceProperty(this.dataSourceUtil, url);
            dataSourceProperty.getDruid().setBreakAfterAcquireFailure(Boolean.valueOf(false));
            dataSourceProperty.setLazy(Boolean.valueOf(false));
            properties.getDatasource().put(properties.getPrimary(), dataSourceProperty);
        }
    }

    @Bean
    public Advisor myDynamicDatasourceGeneratorAdvisor(DsProcessor dsProcessor) {
        DynamicGeneratorInterceptor interceptor = new DynamicGeneratorInterceptor(true, dsProcessor);
        return new DynamicDataSourceAnnotationAdvisor((MethodInterceptor)interceptor, DS.class){
            private final AspectJExpressionPointcut pointcut;
            {
                this.pointcut = new AspectJExpressionPointcut();
                this.pointcut.setExpression("within(com.bringspring.common.database.plugins.DynamicSourceGeneratorInterface+) && @target(com.baomidou.dynamic.datasource.annotation.DS)");
            }

            public Pointcut getPointcut() {
                return this.pointcut;
            }
        };
    }

    public Resource[] resolveMapperLocations() {
        PathMatchingResourcePatternResolver resourceResolver = new PathMatchingResourcePatternResolver();
        ArrayList<String> mapperLocations = new ArrayList<String>();
        mapperLocations.add("classpath*:mapper/**.xml");
        mapperLocations.add("classpath*:mapper/*/*.xml");
        mapperLocations.add("classpath*:mapper/*/*/*.xml");
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (String mapperLocation : mapperLocations) {
            try {
                Resource[] mappers = resourceResolver.getResources(mapperLocation);
                resources.addAll(Arrays.asList(mappers));
            }
            catch (IOException iOException) {}
        }
        return resources.toArray(new Resource[0]);
    }

    public SqlSessionFactory createSqlSessionFactory(DataSource dataSource, ISqlInjector sqlInjector) throws Exception {
        MybatisSqlSessionFactoryBean bean = new MybatisSqlSessionFactoryBean();
        bean.setDataSource(dataSource);
        GlobalConfig globalConfig = new GlobalConfig();
        globalConfig.setMetaObjectHandler((MetaObjectHandler)new MybatisPlusMetaObjectHandler());
        bean.setGlobalConfig(globalConfig);
        if (this.configValueUtil.isEnableLogicDelete()) {
            globalConfig.setDbConfig(new GlobalConfig.DbConfig());
            globalConfig.getDbConfig().setLogicDeleteField("deleteMark");
            globalConfig.getDbConfig().setLogicDeleteValue(GlobalConst.LOGIC_DELETE_VALUE.toString());
            globalConfig.getDbConfig().setLogicNotDeleteValue(String.valueOf(GlobalConst.LOGIC_NO_DELETE_VALUE));
        }
        sqlInjector = new MyDefaultSqlInjector((ISqlInjector)sqlInjector, this.configValueUtil);
        globalConfig.setSqlInjector(sqlInjector);
        ArrayList<Object> mybatisPlugins = new ArrayList<Object>();
        mybatisPlugins.add(new ResultSetInterceptor());
        mybatisPlugins.add(new MyDynamicDataSourceAutoRollbackInterceptor());
        mybatisPlugins.add(this.pageHelper());
        if (this.configValueUtil.isMultiTenancy()) {
            mybatisPlugins.add(this.myTenantMasterSlaveAutoRoutingPlugin(dataSource));
        }
        if (DynamicDataSourceUtil.dynamicDataSourceProperties.getDatasource().keySet().stream().anyMatch(k -> k.startsWith("slave"))) {
            mybatisPlugins.add(this.myDefaultMasterSlaveAutoRoutingPlugin(dataSource));
        }
        bean.setVfs(SpringBootVFS.class);
        bean.setTypeAliasesPackage(ALIASES_PACKAGE);
        bean.setMapperLocations(this.resolveMapperLocations());
        bean.setConfiguration(this.configuration(dataSource));
        bean.setPlugins(mybatisPlugins.toArray(new Interceptor[mybatisPlugins.size()]));
        return bean.getObject();
    }

    public PageInterceptor pageHelper() {
        PageInterceptor pageHelper = new PageInterceptor();
        Properties properties = new Properties();
        properties.setProperty("dialectAlias", "kingbasees8=com.github.pagehelper.dialect.helper.MySqlDialect");
        properties.setProperty("autoRuntimeDialect", "true");
        properties.setProperty("offsetAsPageNum", "false");
        properties.setProperty("rowBoundsWithCount", "false");
        properties.setProperty("pageSizeZero", "true");
        properties.setProperty("reasonable", "false");
        properties.setProperty("supportMethodsArguments", "false");
        properties.setProperty("returnPageInfo", "none");
        pageHelper.setProperties(properties);
        return pageHelper;
    }

    public MybatisConfiguration configuration(DataSource dataSource) {
        MybatisConfiguration mybatisConfiguration = new MybatisConfiguration(this){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void addMappedStatement(MappedStatement ms) {
                String string = MybatisPlusConfig.ALIASES_PACKAGE;
                synchronized (MybatisPlusConfig.ALIASES_PACKAGE) {
                    super.addMappedStatement(ms);
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        };
        mybatisConfiguration.setMapUnderscoreToCamelCase(false);
        mybatisConfiguration.setCacheEnabled(false);
        mybatisConfiguration.setCallSettersOnNulls(true);
        mybatisConfiguration.addInterceptor((Interceptor)this.mybatisPlusInterceptor());
        mybatisConfiguration.setLogImpl(Slf4jImpl.class);
        mybatisConfiguration.setJdbcTypeForNull(JdbcType.NULL);
        return mybatisConfiguration;
    }

    @Bean
    public IKeyGenerator keyGenerator() {
        return new H2KeyGenerator();
    }
}

