/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.database.datatype.limit;

import com.bringspring.common.database.datatype.db.DtMySQLEnum;
import com.bringspring.common.database.datatype.db.interfaces.DtInterface;
import com.bringspring.common.database.datatype.db.interfaces.DtLimitBase;
import com.bringspring.common.database.datatype.limit.base.DtLimitModel;
import com.bringspring.common.database.datatype.limit.util.DtLimitUtil;
import com.bringspring.common.database.datatype.model.DtModel;
import com.bringspring.common.database.datatype.model.DtModelDTO;
import java.util.function.BiFunction;
import lombok.Generated;

public class StringLimit
extends DtLimitBase {
    public static final String CATEGORY = "type-String";
    public static final String JAVA_TYPE = "String";

    @Override
    public String initDtCategory() {
        return CATEGORY;
    }

    public StringLimit(Boolean modify) {
        this.isModifyFlag = modify;
    }

    @Override
    public DtModel convert(DtModelDTO dto) {
        DtInterface originEnum = dto.getDtEnum();
        DtInterface targetEnum = dto.getConvertTargetDtEnum();
        DtModel dataTypeModel = new DtModel(targetEnum);
        this.special(dto);
        if (this.isModifyFlag.booleanValue()) {
            boolean targetCharFlag;
            BiFunction<Long, DtLimitModel, Long> setMod = (inputVarLength, varLengthLm) -> {
                Long targetLength = DtLimitUtil.convertCharacter(inputVarLength, dto.getConvertType(), varLengthLm);
                dataTypeModel.setFormatLengthStr(targetLength.toString());
                return targetLength;
            };
            boolean originBigFlag = originEnum.getBitLengthLm() != null;
            boolean originCharFlag = originEnum.getCharLengthLm() != null;
            boolean targetBigFlag = targetEnum.getBitLengthLm() != null;
            boolean bl = targetCharFlag = targetEnum.getCharLengthLm() != null;
            if (originBigFlag && targetCharFlag) {
                dataTypeModel.setCharLength(setMod.apply(dto.getBitLength() / 3L, targetEnum.getCharLengthLm()));
            } else if (originCharFlag && targetBigFlag) {
                dataTypeModel.setBitLength(setMod.apply(dto.getCharLength() * 3L, targetEnum.getBitLengthLm()));
            } else if (originBigFlag && targetBigFlag) {
                dataTypeModel.setBitLength(setMod.apply(dto.getBitLength(), targetEnum.getBitLengthLm()));
            } else if (originCharFlag) {
                dataTypeModel.setCharLength(setMod.apply(dto.getCharLength(), targetEnum.getCharLengthLm()));
            }
        }
        return dataTypeModel;
    }

    public void special(DtModelDTO dto) {
        DtInterface originEnum = dto.getDtEnum();
        if (originEnum.getDbType().equals("MySQL") && originEnum.getDataType().equals(DtMySQLEnum.BIT.getDataType()) && dto.getCharLength() == 1L) {
            dto.setCharLength(15L);
        }
    }

    @Generated
    public StringLimit() {
    }
}

