/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.database.datatype.model;

import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.database.datatype.db.interfaces.DtInterface;
import com.bringspring.common.database.datatype.limit.base.DtModelBase;
import com.bringspring.common.database.datatype.model.DtModel;
import com.bringspring.common.database.datatype.utils.DataTypeUtil;
import com.bringspring.common.database.datatype.viewshow.ViewDataTypeEnum;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Generated;

public class DtModelDTO
extends DtModelBase {
    @JsonIgnore
    private DtInterface convertTargetDtEnum;
    public static final String DB_VAL = "DB_VAL";
    public static final String FIX_VAL = "FIX_VAL";
    public static final String VIEW_VAL = "VIEW_VAL";
    private String convertType = "VIEW_VAL";

    public DtModelDTO(String dataType, String dtLength, String dbEncode, boolean viewFlag) throws Exception {
        if (StringUtils.isEmpty(dtLength)) {
            dtLength = "-1";
        }
        if (dtLength.contains(",")) {
            String[] split = dtLength.split(",");
            if (DataTypeUtil.numFlag(split[0], split[1]).booleanValue()) {
                this.charLength = Long.parseLong(split[0]);
                this.bitLength = Long.parseLong(split[0]);
                this.numPrecision = Integer.parseInt(split[0]);
                this.numScale = Integer.parseInt(split[1]);
            }
        } else if (DataTypeUtil.numFlag(dtLength).booleanValue()) {
            this.charLength = Long.parseLong(dtLength);
            this.bitLength = Long.parseLong(dtLength);
            this.numPrecision = Integer.parseInt(dtLength);
        }
        if (viewFlag) {
            this.dtEnum = DtInterface.newInstanceByView(dataType, dbEncode);
        }
        if (this.dtEnum == null) {
            this.dtEnum = DtInterface.newInstanceByDt(dataType, dbEncode);
        }
        if (this.dtEnum == null) {
            new DataException(MsgCode.DB013.get(dbEncode, dataType)).printStackTrace();
        }
        this.convertTargetDtEnum = this.dtEnum;
    }

    public DtModelDTO(DtInterface dtEnum, Long charLength, Integer numPrecision, Integer numScale) {
        this.dtEnum = dtEnum;
        this.numPrecision = numPrecision;
        this.numScale = numScale;
        if (dtEnum.getCharLengthLm() != null) {
            this.charLength = charLength;
        } else if (dtEnum.getBitLengthLm() != null) {
            this.bitLength = charLength;
        }
    }

    public static String getStringFixedDt(String dbEncode) throws Exception {
        DtInterface dtEnum = DtInterface.newInstanceByView(ViewDataTypeEnum.VARCHAR.getViewFieldType(), dbEncode);
        if (dtEnum != null) {
            DtModelDTO dto = new DtModelDTO(dtEnum, -1L, -1, -1);
            dto.setConvertType(FIX_VAL);
            return dto.convert().formatDataType();
        }
        return "varchar(50)";
    }

    public DtModel convert() {
        return this.dtEnum.getDtLimit().convert(this);
    }

    @Generated
    public DtInterface getConvertTargetDtEnum() {
        return this.convertTargetDtEnum;
    }

    @Generated
    public String getConvertType() {
        return this.convertType;
    }

    @Generated
    public DtModelDTO setConvertTargetDtEnum(DtInterface convertTargetDtEnum) {
        this.convertTargetDtEnum = convertTargetDtEnum;
        return this;
    }

    @Generated
    public DtModelDTO setConvertType(String convertType) {
        this.convertType = convertType;
        return this;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DtModelDTO)) {
            return false;
        }
        DtModelDTO other = (DtModelDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DtInterface this$convertTargetDtEnum = this.getConvertTargetDtEnum();
        DtInterface other$convertTargetDtEnum = other.getConvertTargetDtEnum();
        if (this$convertTargetDtEnum == null ? other$convertTargetDtEnum != null : !this$convertTargetDtEnum.equals(other$convertTargetDtEnum)) {
            return false;
        }
        String this$convertType = this.getConvertType();
        String other$convertType = other.getConvertType();
        return !(this$convertType == null ? other$convertType != null : !this$convertType.equals(other$convertType));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DtModelDTO;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        DtInterface $convertTargetDtEnum = this.getConvertTargetDtEnum();
        result = result * 59 + ($convertTargetDtEnum == null ? 43 : $convertTargetDtEnum.hashCode());
        String $convertType = this.getConvertType();
        result = result * 59 + ($convertType == null ? 43 : $convertType.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "DtModelDTO(convertTargetDtEnum=" + String.valueOf(this.getConvertTargetDtEnum()) + ", convertType=" + this.getConvertType() + ")";
    }

    @Generated
    public DtModelDTO() {
    }
}

