/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.database.model.interfaces;

import com.bringspring.common.exception.DataException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;

@FunctionalInterface
public interface JdbcCreUpDel<T> {
    public T execute() throws SQLException;

    public static void setData(PreparedStatement preparedStatement, List<?> data) throws SQLException {
        if (data != null) {
            for (int i = 0; i < data.size(); ++i) {
                preparedStatement.setObject(i + 1, data.get(i));
            }
        }
    }

    public static <T> T get(Connection conn, JdbcCreUpDel<T> creUpDel) throws SQLException {
        try {
            conn.setAutoCommit(false);
            T result = creUpDel.execute();
            conn.commit();
            return result;
        }
        catch (SQLException e) {
            throw DataException.rollbackDataException(e, conn);
        }
    }
}

