/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.database.plugins;

import com.baomidou.mybatisplus.core.plugins.InterceptorIgnoreHelper;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.baomidou.mybatisplus.core.toolkit.TableNameParser;
import com.baomidou.mybatisplus.extension.plugins.handler.TableNameHandler;
import com.baomidou.mybatisplus.extension.plugins.inner.DynamicTableNameInnerInterceptor;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.database.plugins.ITenantPlugin;
import com.bringspring.common.database.util.DynamicDataSourceUtil;
import com.bringspring.common.database.util.NotTenantPluginHolder;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.TenantHolder;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import lombok.Generated;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySchemaInnerInterceptor
extends DynamicTableNameInnerInterceptor
implements ITenantPlugin {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MySchemaInnerInterceptor.class);
    private Runnable hook;
    private TableNameHandler tableNameHandler;

    public void setHook(Runnable hook) {
        this.hook = hook;
    }

    public void beforeQuery(Executor executor, MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) throws SQLException {
        if (TenantHolder.getLocalTenantCache() == null) {
            this.printNoTenant(v -> log.warn("\u672a\u8bbe\u7f6e\u79df\u6237\u4fe1\u606f, \u7981\u6b62\u67e5\u8be2\u6570\u636e\u5e93, {}, {}, {}, {}", new Object[]{v.getUserId(), v.getUrl(), v.getToken(), v.getStack()}));
            throw new DataException(MsgCode.LOG113.get());
        }
        if (!TenantHolder.getLocalTenantCache().isSchema()) {
            return;
        }
        if (NotTenantPluginHolder.isNotSwitch().booleanValue()) {
            NotTenantPluginHolder.clearNotSwitchFlag();
            return;
        }
        if (!DynamicDataSourceUtil.isPrimaryDataSoure()) {
            return;
        }
        PluginUtils.MPBoundSql mpBs = PluginUtils.mpBoundSql((BoundSql)boundSql);
        if (!InterceptorIgnoreHelper.willIgnoreDynamicTableName((String)ms.getId())) {
            mpBs.sql(this.changeTable(mpBs.sql()));
        }
    }

    public void beforePrepare(StatementHandler sh, Connection connection, Integer transactionTimeout) {
        if (TenantHolder.getLocalTenantCache() == null) {
            this.printNoTenant(v -> log.warn("\u672a\u8bbe\u7f6e\u79df\u6237\u4fe1\u606f, \u7981\u6b62\u67e5\u8be2\u6570\u636e\u5e93, {}, {}, {}, {}", new Object[]{v.getUserId(), v.getUrl(), v.getToken(), v.getStack()}));
            throw new DataException(MsgCode.LOG113.get());
        }
        if (!TenantHolder.getLocalTenantCache().isSchema()) {
            return;
        }
        if (NotTenantPluginHolder.isNotSwitch().booleanValue()) {
            NotTenantPluginHolder.clearNotSwitchFlag();
            return;
        }
        if (!DynamicDataSourceUtil.isPrimaryDataSoure()) {
            return;
        }
        PluginUtils.MPStatementHandler mpSh = PluginUtils.mpStatementHandler((StatementHandler)sh);
        MappedStatement ms = mpSh.mappedStatement();
        SqlCommandType sct = ms.getSqlCommandType();
        if (!(sct != SqlCommandType.INSERT && sct != SqlCommandType.UPDATE && sct != SqlCommandType.DELETE || InterceptorIgnoreHelper.willIgnoreDynamicTableName((String)ms.getId()))) {
            PluginUtils.MPBoundSql mpBs = mpSh.mPBoundSql();
            mpBs.sql(this.changeTable(mpBs.sql()));
        }
    }

    public String changeTable(String sql) {
        ExceptionUtils.throwMpe((null == this.tableNameHandler ? 1 : 0) != 0, (String)"Please implement TableNameHandler processing logic", (Object[])new Object[0]);
        TableNameParser parser = new TableNameParser(sql);
        ArrayList names = new ArrayList();
        parser.accept(names::add);
        StringBuilder builder = new StringBuilder();
        int last = 0;
        for (TableNameParser.SqlToken name : names) {
            int start = name.getStart();
            if (start != last) {
                builder.append(sql, last, start);
                builder.append(this.tableNameHandler.dynamicTableName(sql, name.getValue()));
            }
            last = name.getEnd();
        }
        if (last != sql.length()) {
            builder.append(sql.substring(last));
        }
        if (this.hook != null) {
            this.hook.run();
        }
        return builder.toString();
    }

    @Generated
    public Runnable getHook() {
        return this.hook;
    }

    @Generated
    public TableNameHandler getTableNameHandler() {
        return this.tableNameHandler;
    }

    @Generated
    public void setTableNameHandler(TableNameHandler tableNameHandler) {
        this.tableNameHandler = tableNameHandler;
    }

    @Generated
    public MySchemaInnerInterceptor() {
    }

    @Generated
    public MySchemaInnerInterceptor(Runnable hook, TableNameHandler tableNameHandler) {
        this.hook = hook;
        this.tableNameHandler = tableNameHandler;
    }
}

