/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.database.sql.enums.base;

import com.bringspring.common.database.model.dto.PrepSqlDTO;
import com.bringspring.common.database.model.entity.DbLinkEntity;
import com.bringspring.common.database.model.interfaces.DbSourceOrDbLink;
import com.bringspring.common.database.source.DbBase;
import com.bringspring.common.database.sql.enums.base.SqlComEnum;
import com.bringspring.common.database.sql.model.DbStruct;
import com.bringspring.common.database.sql.util.SqlFrameUtil;
import com.bringspring.common.database.util.DbTypeUtil;
import com.bringspring.common.database.util.TenantDataSourceUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public interface SqlFrameBase {
    public String getSqlFrame();

    public String getDbEncode();

    public String name();

    default public void setStructParams(String table, DbStruct dbStruct, List<String> list) {
    }

    default public PrepSqlDTO getPrepSqlDto(DbSourceOrDbLink dataSourceMod, String table) {
        ArrayList<String> list = new ArrayList<String>();
        TenantDataSourceUtil.initDataSourceTenantDbName(dataSourceMod);
        this.setStructParams(table, dataSourceMod.getDbStruct(), list);
        return new PrepSqlDTO(this.getSqlFrame(), list).withConn((DbLinkEntity)dataSourceMod);
    }

    default public String getOutSql(String ... params) throws DataException {
        return this.getOutSqlByDb(null, params);
    }

    default public String getOutSqlByDb(String dbEncode, String ... params) throws DataException {
        DbBase dbBase;
        SqlComEnum sqlComEnum = null;
        SqlFrameBase sqlFrameBase = null;
        try {
            dbBase = DbTypeUtil.getEncodeDb(dbEncode);
        }
        catch (Exception e) {
            dbBase = null;
        }
        if (this instanceof SqlComEnum) {
            sqlComEnum = (SqlComEnum)this;
            if (dbBase != null) {
                sqlFrameBase = sqlComEnum.getSqlFrameEnum(dbEncode);
            }
            if (sqlFrameBase == null) {
                sqlFrameBase = sqlComEnum.getBaseSqlEnum();
            }
        } else if (dbBase == null) {
            for (SqlComEnum conEnum : SqlComEnum.values()) {
                sqlFrameBase = conEnum.getSqlFrameEnum(this);
                if (sqlFrameBase == null) continue;
                sqlComEnum = conEnum;
                break;
            }
            if (sqlFrameBase == null) {
                throw new DataException("\u6b64\u679a\u4e3eSQL\u6846\u67b6\u672a\u88ab\u5f15\u7528");
            }
        } else {
            throw new DataException("\u8bf7\u4f7f\u7528SqlComEnum\u6765\u505a\u5f15\u7528");
        }
        return SqlFrameUtil.outSqlCommon(sqlFrameBase, sqlComEnum.getFrameParamList(), params);
    }

    default public String createIncrement(String sqlFrame, Map<String, String> paramsMap) {
        if (StringUtils.isNotEmpty(paramsMap.get("[AUTO_INCREMENT]"))) {
            sqlFrame = sqlFrame.replace("[[NOT] [NULL]]", "").replace("[<DEFAULT> {defaultValue}]", "");
        }
        return sqlFrame;
    }

    default public String createPrimaryKeys(String sqlFrame, Map<String, String> paramsMap) {
        Object primaryStr = "";
        if (StringUtils.isNotEmpty(paramsMap.get("{primarykeys}"))) {
            primaryStr = "\n, PRIMARY KEY (" + paramsMap.get("{primarykeys}") + ")";
        }
        return sqlFrame.replace("{primarykeys}", (CharSequence)primaryStr);
    }

    default public String createIndex() {
        return "";
    }
}

