/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.database.sql.util;

import com.bringspring.common.database.sql.enums.base.SqlFrameBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.util.HtmlUtils;

public class SqlFrameUtil {
    private static final Pattern BRACKET = Pattern.compile("\\<.+?\\>");
    private static final Pattern BRACKET2 = Pattern.compile("\\[.+?\\]");

    public static String keyWordTrim(String keyWord) {
        return keyWord.trim();
    }

    public static String htmlE(String str) {
        if (str != null) {
            return HtmlUtils.htmlEscape((String)str, (String)"UTF-8");
        }
        return null;
    }

    public static String formatSqlFrame(String sqlFrame) {
        sqlFrame = sqlFrame.replace("<", "").replace(">", "").replace("[", "").replace("]", "");
        return sqlFrame.replace("\u300aschema\u300b.", "");
    }

    public static String outSqlCommon(SqlFrameBase sqlFrameEnum, List<String> frameParamList, String ... params) {
        int i;
        String sqlFrame = sqlFrameEnum.getSqlFrame();
        List<String> paramList = Arrays.asList(params);
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        for (i = 0; i < paramList.size(); ++i) {
            paramsMap.put(frameParamList.get(i), paramList.get(i));
        }
        sqlFrame = sqlFrameEnum.createIncrement(sqlFrame, paramsMap);
        sqlFrame = sqlFrameEnum.createPrimaryKeys(sqlFrame, paramsMap);
        for (i = 0; i < frameParamList.size(); ++i) {
            sqlFrame = sqlFrame.replace(frameParamList.get(i), "?_" + i);
        }
        sqlFrame = SqlFrameUtil.formatSqlFrame(sqlFrame);
        for (i = 0; i < paramList.size(); ++i) {
            String param = paramList.get(i) != null ? paramList.get(i) : "";
            sqlFrame = sqlFrame.replace("?_" + i, param);
        }
        return sqlFrame;
    }

    public static List<String> splitStrRepeat(String str, Integer index) {
        ArrayList<String> splitList = new ArrayList<String>();
        while (str.length() > index) {
            String[] splitStrArrays = new String[]{str.substring(0, index), str.substring(index)};
            splitList.add(splitStrArrays[0]);
            str = splitStrArrays[1];
        }
        if (StringUtils.isNotEmpty((CharSequence)str)) {
            splitList.add(str);
        }
        return splitList;
    }
}

