/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.filter;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.filter.HttpUtil;
import com.bringspring.common.filter.RepeatSubmit;
import com.bringspring.common.filter.RepeatSubmitInterceptor;
import com.bringspring.common.filter.RepeatedlyRequestWrapper;
import com.bringspring.common.util.CacheUtil;
import com.bringspring.common.util.context.SpringContext;
import jakarta.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RepeatSubmitRule
extends RepeatSubmitInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RepeatSubmitRule.class);
    public final String REPEAT_PARAMS = "repeatParams";
    public final String REPEAT_TIME = "repeatTime";
    public static final String REPEAT_SUBMIT_KEY = "repeat_submit:";

    @Override
    public boolean isRepeatSubmit(HttpServletRequest request, RepeatSubmit annotation) {
        CacheUtil cacheUtil = SpringContext.getBean(CacheUtil.class);
        String mobile = request.getHeader("Authorization");
        int interval = 3000;
        if (ObjectUtil.isNotNull((Object)annotation)) {
            interval = annotation.interval();
        }
        String nowParams = "";
        if (request instanceof RepeatedlyRequestWrapper) {
            RepeatedlyRequestWrapper repeatedlyRequest = (RepeatedlyRequestWrapper)request;
            nowParams = HttpUtil.getBodyString((HttpServletRequest)repeatedlyRequest);
        } else {
            nowParams = HttpUtil.getBodyString(request);
        }
        if (StringUtils.isEmpty((CharSequence)nowParams)) {
            nowParams = JSON.toJSONString((Object)request.getParameterMap());
        }
        HashMap<String, Object> nowDataMap = new HashMap<String, Object>();
        nowDataMap.put("repeatParams", nowParams);
        nowDataMap.put("repeatTime", System.currentTimeMillis());
        String url = request.getRequestURI();
        String cacheRepeatKey = REPEAT_SUBMIT_KEY + url + mobile;
        HashMap<String, HashMap<String, Object>> cacheMap = new HashMap<String, HashMap<String, Object>>();
        cacheMap.put(url, nowDataMap);
        Boolean isExist = null;
        try {
            isExist = cacheUtil.setStringByAtomicity(cacheRepeatKey, JSON.toJSONString(cacheMap), Integer.valueOf(interval).longValue(), TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            log.error("[\u6821\u9a8c\u9632\u91cd\u590d\u63d0\u4ea4]\u539f\u5b50\u6027\u6dfb\u52a0\u6570\u636e\u5931\u8d25\uff0c\u539f\u56e0:{}", (Throwable)e);
            return false;
        }
        if (Boolean.FALSE.equals(isExist)) {
            Map preDataMap;
            Object sessionObj = null;
            try {
                sessionObj = cacheUtil.query("RepeatSubmitCacheSpace", cacheRepeatKey);
            }
            catch (Exception e) {
                log.error("[\u6821\u9a8c\u9632\u91cd\u590d\u63d0\u4ea4]redis\u83b7\u53d6\u6570\u636e\u5931\u8d25\uff0c\u539f\u56e0:{}", (Throwable)e);
                return false;
            }
            JSONObject sessionMap = JSONObject.parseObject((String)sessionObj.toString());
            if (sessionMap.containsKey((Object)url) && this.compareParams(nowDataMap, preDataMap = (Map)sessionMap.get((Object)url)) && this.compareTime(nowDataMap, preDataMap, interval)) {
                return true;
            }
        }
        return false;
    }

    private boolean compareParams(Map<String, Object> nowMap, Map<String, Object> preMap) {
        String nowParams = (String)nowMap.get("repeatParams");
        String preParams = (String)preMap.get("repeatParams");
        return nowParams.equals(preParams);
    }

    private boolean compareTime(Map<String, Object> nowMap, Map<String, Object> preMap, int interval) {
        long time2;
        long time1 = (Long)nowMap.get("repeatTime");
        return time1 - (time2 = ((Long)preMap.get("repeatTime")).longValue()) < (long)interval;
    }
}

