/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.license.client;

import com.bringspring.common.license.client.LicenseManagerHolder;
import com.bringspring.common.license.client.model.LicenseVerifyParam;
import com.bringspring.common.license.license.model.CustomKeyStoreParam;
import de.schlichtherle.license.CipherParam;
import de.schlichtherle.license.DefaultCipherParam;
import de.schlichtherle.license.DefaultLicenseParam;
import de.schlichtherle.license.KeyStoreParam;
import de.schlichtherle.license.LicenseContent;
import de.schlichtherle.license.LicenseContentException;
import de.schlichtherle.license.LicenseManager;
import de.schlichtherle.license.LicenseParam;
import de.schlichtherle.util.ObfuscatedString;
import java.io.File;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.prefs.Preferences;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseVerify {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LicenseVerify.class);
    private static final String EXC_LICENSE_HAS_EXPIRED = new ObfuscatedString(new long[]{1000558500458715757L, -6998261911041258483L, -5490039629745846648L, 3561172928787106880L}).toString();

    public synchronized LicenseContent install(LicenseVerifyParam param) throws Exception {
        LicenseContent result = null;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            LicenseManager licenseManager = LicenseManagerHolder.getInstance(this.initLicenseParam(param));
            licenseManager.uninstall();
            File file = new File(param.getLicensePath());
            result = licenseManager.install(file);
            log.debug(MessageFormat.format("\u8bc1\u4e66\u5b89\u88c5\u6210\u529f\uff0c\u8bc1\u4e66\u6709\u6548\u671f\uff1a{0} - {1}", format.format(result.getNotBefore()), format.format(result.getNotAfter())));
        }
        catch (LicenseContentException lce) {
            if (EXC_LICENSE_HAS_EXPIRED.equals(lce.getMessage())) {
                log.error("\u8bc1\u4e66\u5b89\u88c5\u5931\u8d25\uff0c\u8bc1\u4e66\u5df2\u8fc7\u671f\uff01");
            } else {
                log.error("\u8bc1\u4e66\u5b89\u88c5\u5931\u8d25\uff01", (Throwable)lce);
            }
            throw lce;
        }
        catch (Exception e) {
            log.error("\u8bc1\u4e66\u5b89\u88c5\u5931\u8d25\uff01", (Throwable)e);
            throw e;
        }
        return result;
    }

    public boolean verify() {
        LicenseManager licenseManager = LicenseManagerHolder.getInstance(null);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            LicenseContent licenseContent = licenseManager.verify();
            log.debug(MessageFormat.format("\u8bc1\u4e66\u6821\u9a8c\u901a\u8fc7\uff0c\u8bc1\u4e66\u6709\u6548\u671f\uff1a{0} - {1}", format.format(licenseContent.getNotBefore()), format.format(licenseContent.getNotAfter())));
            return true;
        }
        catch (Exception e) {
            log.error("\u8bc1\u4e66\u6821\u9a8c\u5931\u8d25\uff01", (Throwable)e);
            return false;
        }
    }

    public boolean getLicenseCheckModel() {
        LicenseManager licenseManager = LicenseManagerHolder.getInstance(null);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            LicenseContent licenseContent = licenseManager.verify();
            log.debug(MessageFormat.format("\u8bc1\u4e66\u6821\u9a8c\u901a\u8fc7\uff0c\u8bc1\u4e66\u6709\u6548\u671f\uff1a{0} - {1}", format.format(licenseContent.getNotBefore()), format.format(licenseContent.getNotAfter())));
            return true;
        }
        catch (Exception e) {
            log.error("\u8bc1\u4e66\u6821\u9a8c\u5931\u8d25\uff01", (Throwable)e);
            return false;
        }
    }

    private LicenseParam initLicenseParam(LicenseVerifyParam param) {
        Preferences preferences = Preferences.userNodeForPackage(LicenseVerify.class);
        DefaultCipherParam cipherParam = new DefaultCipherParam(param.getStorePass());
        CustomKeyStoreParam publicStoreParam = new CustomKeyStoreParam(LicenseVerify.class, param.getPublicKeysStorePath(), param.getPublicAlias(), param.getStorePass(), null);
        return new DefaultLicenseParam(param.getSubject(), preferences, (KeyStoreParam)publicStoreParam, (CipherParam)cipherParam);
    }
}

