/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.security.filter;

import cn.dev33.satoken.context.SaHolder;
import cn.dev33.satoken.filter.SaServletFilter;
import cn.dev33.satoken.router.SaRouter;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.database.util.TenantDataSourceUtil;
import com.bringspring.common.properties.SecurityProperties;
import com.bringspring.common.util.StringUtils;
import jakarta.annotation.PostConstruct;
import java.util.function.Predicate;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.core.annotation.Order;

@Order(value=-98)
public class SecurityFilter
extends SaServletFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SecurityFilter.class);
    private SecurityProperties securityProperties;
    private ConfigValueUtil configValueUtil;
    private Predicate<Object> checkRequestOrigin = t -> true;

    public SecurityFilter(SecurityProperties securityProperties, ConfigValueUtil configValueUtil) {
        this.securityProperties = securityProperties;
        this.configValueUtil = configValueUtil;
        this.setAuth(o -> this.initAuthenticationInfo());
        this.setBeforeAuth(o -> this.checkRequestOrigin.test(null));
    }

    protected void initAuthenticationInfo() {
        UserInfo userInfo;
        UserProvider.getUser();
        if (this.configValueUtil.isMultiTenancy() && StringUtils.isNotEmpty((userInfo = UserProvider.getUser()).getTenantId())) {
            TenantDataSourceUtil.switchTenant(userInfo.getTenantId());
        }
    }

    @ConditionalOnClass(name={"org.springframework.cloud.loadbalancer.annotation.LoadBalancerClient"})
    @PostConstruct
    public void onCloudCheckRequestOrigin() {
        this.checkRequestOrigin = t -> {
            if (this.securityProperties.isEnableInnerAuth()) {
                SaRouter.match((String[])new String[]{"/favicon.ico"}).stop();
                SaRouter.match((String[])new String[]{"/**"}).match(r -> {
                    String innerToken = SaHolder.getRequest().getHeader("SA-SAME-TOKEN");
                    String innerGatewayToken = SaHolder.getRequest().getHeader("SA-SAME-TOKEN_GATEWAY");
                    if (!UserProvider.isValidInnerToken(innerGatewayToken) && !UserProvider.isValidInnerToken(innerToken)) {
                        log.error("\u975e\u6cd5\u8bf7\u6c42: {}, {}", (Object)SaHolder.getRequest().getRequestPath(), (Object)innerToken);
                        return true;
                    }
                    return false;
                }).back((Object)MsgCode.FA034.get());
            }
            return true;
        };
    }
}

